/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.views.nodes;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.index.IndexedArtifact;
import org.eclipse.m2e.core.internal.index.nexus.IndexedArtifactGroup;
import org.eclipse.m2e.core.internal.index.nexus.NexusIndexManager;
import org.eclipse.m2e.core.ui.internal.views.nodes.IArtifactNode;
import org.eclipse.m2e.core.ui.internal.views.nodes.IMavenRepositoryNode;
import org.eclipse.m2e.core.ui.internal.views.nodes.IndexedArtifactNode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class IndexedArtifactGroupNode
implements IMavenRepositoryNode,
IArtifactNode {
    private IndexedArtifactGroup indexedArtifactGroup;
    private Object[] kids = null;

    public IndexedArtifactGroupNode(IndexedArtifactGroup group) {
        this.indexedArtifactGroup = group;
    }

    @Override
    public Object[] getChildren() {
        NexusIndexManager indexManager = (NexusIndexManager)MavenPlugin.getIndexManager();
        IndexedArtifactGroup resolvedGroup = indexManager.resolveGroup(this.indexedArtifactGroup);
        ArrayList<IMavenRepositoryNode> results = new ArrayList<IMavenRepositoryNode>();
        Collection groups = resolvedGroup.getNodes().values();
        for (IndexedArtifactGroup group : groups) {
            IndexedArtifactGroupNode node = new IndexedArtifactGroupNode(group);
            results.add(node);
        }
        Collection artifacts = resolvedGroup.getFiles().values();
        for (IndexedArtifact artifact : artifacts) {
            IndexedArtifactNode artifactNode = new IndexedArtifactNode(artifact);
            results.add(artifactNode);
        }
        this.kids = results.toArray(new Object[results.size()]);
        return this.kids;
    }

    @Override
    public String getName() {
        String prefix = this.indexedArtifactGroup.getPrefix();
        int n = prefix.lastIndexOf(46);
        return n < 0 ? prefix : prefix.substring(n + 1);
    }

    @Override
    public boolean hasChildren() {
        return true;
    }

    @Override
    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    }

    @Override
    public String getDocumentKey() {
        return this.indexedArtifactGroup.getPrefix();
    }

    @Override
    public boolean isUpdating() {
        return false;
    }
}

