/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.calls.rcp;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.recommenders.calls.ICallModel;
import org.eclipse.recommenders.jdt.AstBindings;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IMethodName;

public class AstDefUseFinder
extends ASTVisitor {
    private static final String VAR_THIS = "this";
    private static final String VAR_SUPER = "super";
    private IMethodName definingMethod;
    private ICallModel.DefinitionKind defKind = ICallModel.DefinitionKind.UNKNOWN;
    private final List<IMethodName> calls = Lists.newLinkedList();
    private final MethodDeclaration method;
    private final String varname;

    public AstDefUseFinder(String varname, MethodDeclaration method) {
        this.varname = (String)Checks.ensureIsNotNull((Object)varname);
        this.method = (MethodDeclaration)Checks.ensureIsNotNull((Object)method);
        if (VAR_THIS.equals(varname) || VAR_SUPER.equals(varname)) {
            this.defKind = ICallModel.DefinitionKind.THIS;
        }
        method.accept((ASTVisitor)this);
    }

    public List<IMethodName> getCalls() {
        return this.calls;
    }

    public Optional<IMethodName> getDefiningMethod() {
        return Optional.fromNullable((Object)this.definingMethod);
    }

    public ICallModel.DefinitionKind getDefinitionKind() {
        return this.defKind;
    }

    public boolean visit(MethodInvocation node) {
        Expression expr = node.getExpression();
        if (this.receiverExpressionMatchesVarname(expr) || this.maybeThis() && this.isReceiverThis(node)) {
            IMethodBinding b = node.resolveMethodBinding();
            this.registerMethodCallOnReceiver(b);
        }
        return true;
    }

    private boolean receiverExpressionMatchesVarname(Expression exp) {
        if (exp == null) {
            return false;
        }
        switch (exp.getNodeType()) {
            case 40: 
            case 42: {
                Name name = (Name)Checks.cast((Object)exp);
                return this.matchesVarName(name);
            }
            case 52: {
                return this.maybeThis();
            }
        }
        return false;
    }

    private boolean matchesVarName(Name node) {
        if (node == null) {
            return false;
        }
        String name = node.getFullyQualifiedName();
        boolean equals = this.varname.equals(name);
        if (equals && this.defKind == ICallModel.DefinitionKind.UNKNOWN) {
            this.refineDefKindByBinding(node);
        }
        return equals;
    }

    private void refineDefKindByBinding(Name node) {
        IVariableBinding b = (IVariableBinding)Checks.castOrNull((Object)node.resolveBinding());
        if (b == null) {
            return;
        }
        if (b.isField()) {
            this.defKind = ICallModel.DefinitionKind.FIELD;
        } else if (b.isParameter()) {
            this.defKind = ICallModel.DefinitionKind.PARAM;
        }
    }

    private boolean maybeThis() {
        return this.varname.isEmpty() || VAR_THIS.equals(this.varname) || VAR_SUPER.equals(this.varname);
    }

    private boolean isReceiverThis(MethodInvocation mi) {
        Expression expression = mi.getExpression();
        if (expression == null && !this.isStatic(mi)) {
            return true;
        }
        return expression instanceof ThisExpression;
    }

    private boolean isStatic(MethodInvocation call) {
        IMethodBinding binding = call.resolveMethodBinding();
        if (binding != null) {
            return JdtFlags.isStatic((IMethodBinding)binding);
        }
        return false;
    }

    private void registerMethodCallOnReceiver(IMethodBinding b) {
        Optional opt = AstBindings.toMethodName((IMethodBinding)b);
        if (opt.isPresent()) {
            this.calls.add((IMethodName)opt.get());
        }
    }

    public boolean visit(AnonymousClassDeclaration node) {
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        return false;
    }

    public boolean visit(Assignment node) {
        Expression lhs = node.getLeftHandSide();
        Expression rhs = node.getRightHandSide();
        if (this.isCompletionNode(rhs)) {
            block0 : switch (lhs.getNodeType()) {
                case 40: 
                case 42: {
                    break;
                }
                case 52: {
                    this.defKind = ICallModel.DefinitionKind.THIS;
                    break;
                }
                case 45: {
                    this.defKind = ICallModel.DefinitionKind.STRING_LITERAL;
                    break;
                }
                case 2: {
                    this.defKind = ICallModel.DefinitionKind.ARRAY_ACCESS;
                    break;
                }
                case 22: {
                    FieldAccess f = (FieldAccess)lhs;
                    Expression e = f.getExpression();
                    switch (e.getNodeType()) {
                        case 52: {
                            this.defKind = ICallModel.DefinitionKind.THIS;
                            break block0;
                        }
                        case 2: {
                            this.defKind = ICallModel.DefinitionKind.ARRAY_ACCESS;
                        }
                    }
                }
            }
        }
        if (lhs == null) {
            return true;
        }
        switch (lhs.getNodeType()) {
            case 40: 
            case 42: {
                Name n = (Name)Checks.cast((Object)lhs);
                if (this.matchesVarName(n)) break;
                return true;
            }
            default: {
                return true;
            }
        }
        this.evaluateRightHandSideExpression(rhs);
        return true;
    }

    private boolean isCompletionNode(Expression rhs) {
        return rhs instanceof SimpleName && ((SimpleName)rhs).getIdentifier().equals("$missing$");
    }

    private void evaluateRightHandSideExpression(Expression expression) {
        switch (expression.getNodeType()) {
            case 11: {
                CastExpression ce = (CastExpression)Checks.cast((Object)expression);
                this.evaluateRightHandSideExpression(ce.getExpression());
                break;
            }
            case 32: {
                MethodInvocation mi = (MethodInvocation)Checks.cast((Object)expression);
                this.definingMethod = (IMethodName)AstBindings.toMethodName((IMethodBinding)mi.resolveMethodBinding()).orNull();
                this.defKind = ICallModel.DefinitionKind.RETURN;
                break;
            }
            case 48: {
                SuperMethodInvocation smi = (SuperMethodInvocation)Checks.cast((Object)expression);
                this.definingMethod = (IMethodName)AstBindings.toMethodName((IMethodBinding)smi.resolveMethodBinding()).orNull();
                this.defKind = ICallModel.DefinitionKind.RETURN;
                break;
            }
            case 14: {
                ClassInstanceCreation cic = (ClassInstanceCreation)Checks.cast((Object)expression);
                this.definingMethod = (IMethodName)AstBindings.toMethodName((IMethodBinding)cic.resolveConstructorBinding()).orNull();
                this.defKind = ICallModel.DefinitionKind.NEW;
                break;
            }
            case 2: {
                this.defKind = ICallModel.DefinitionKind.ARRAY_ACCESS;
                break;
            }
            case 33: {
                this.defKind = ICallModel.DefinitionKind.NULL_LITERAL;
                break;
            }
            case 42: {
                if (this.defKind != null) break;
                this.defKind = ICallModel.DefinitionKind.LOCAL;
                break;
            }
        }
    }

    public boolean visit(ConstructorInvocation node) {
        if (this.maybeThis()) {
            IMethodBinding b = node.resolveConstructorBinding();
            this.registerMethodCallOnReceiver(b);
        }
        return true;
    }

    public boolean visit(SingleVariableDeclaration node) {
        if (this.matchesVarName((Name)node.getName()) && node.getParent() instanceof MethodDeclaration) {
            this.defKind = ICallModel.DefinitionKind.PARAM;
            this.definingMethod = (IMethodName)AstBindings.toMethodName((IMethodBinding)this.method.resolveBinding()).orNull();
        }
        return true;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (this.maybeThis()) {
            IMethodBinding b = node.resolveConstructorBinding();
            this.registerMethodCallOnReceiver(b);
        }
        return true;
    }

    public boolean visit(SuperMethodInvocation node) {
        if (this.maybeThis()) {
            IMethodBinding b = node.resolveMethodBinding();
            this.registerMethodCallOnReceiver(b);
        }
        return true;
    }

    public boolean visit(VariableDeclarationStatement node) {
        for (VariableDeclarationFragment f : node.fragments()) {
            this.evaluateVariableDeclarationFragment(f);
        }
        return true;
    }

    private void evaluateVariableDeclarationFragment(VariableDeclarationFragment f) {
        Expression expression;
        SimpleName name = f.getName();
        if (this.matchesVarName((Name)name) && (expression = f.getInitializer()) != null) {
            this.evaluateRightHandSideExpression(expression);
        }
    }

    public boolean visit(VariableDeclarationExpression node) {
        for (VariableDeclarationFragment f : node.fragments()) {
            this.evaluateVariableDeclarationFragment(f);
        }
        return true;
    }
}

