/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.utils;

import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public final class Jobs {
    public static final ISchedulingRule EXCLUSIVE = new SequentialSchedulingRule();

    private Jobs() {
        throw new IllegalStateException("Not meant to be instantiated");
    }

    public static IProgressMonitor getProgressGroup() {
        return Job.getJobManager().createProgressGroup();
    }

    public static IProgressMonitor parallel(String task, Job ... jobs) {
        return Jobs.parallel(task, Arrays.asList(jobs));
    }

    public static IProgressMonitor parallel(String task, Iterable<Job> jobs) {
        IProgressMonitor group = Jobs.getProgressGroup();
        try {
            try {
                group.beginTask(task, Iterables.size(jobs));
                for (Job job : jobs) {
                    job.setProgressGroup(group, 1);
                    job.schedule();
                }
                for (Job job : jobs) {
                    job.join();
                }
            }
            catch (InterruptedException interruptedException) {
                group.done();
            }
        }
        finally {
            group.done();
        }
        return group;
    }

    public static IProgressMonitor sequential(String task, Job ... jobs) {
        return Jobs.sequential(task, Arrays.asList(jobs));
    }

    public static IProgressMonitor sequential(String task, Iterable<Job> jobs) {
        SequentialSchedulingRule rule = new SequentialSchedulingRule();
        IProgressMonitor group = Jobs.getProgressGroup();
        try {
            try {
                group.beginTask(task, Iterables.size(jobs));
                for (Job job : jobs) {
                    job.setRule((ISchedulingRule)rule);
                    job.setProgressGroup(group, 1);
                    job.schedule();
                    job.join();
                }
            }
            catch (InterruptedException interruptedException) {
                group.done();
            }
        }
        finally {
            group.done();
        }
        return group;
    }

    public static void wait(IProgressMonitor group, List<Job> jobs) {
        for (Job job : jobs) {
            try {
                job.join();
            }
            catch (InterruptedException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        group.done();
    }

    public static final class SequentialSchedulingRule
    implements ISchedulingRule {
        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

