/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.notifications;

import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.epp.internal.logging.aeri.ui.Events;
import org.eclipse.epp.internal.logging.aeri.ui.model.ServerResponse;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.NoficationAction;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.Notification;

public class ServerResponseNotification
extends Notification {
    private static final int MAX_REPORT_TITLE_CHARACTER_LENGTH = 40;
    private ServerResponse state;

    public ServerResponseNotification(ServerResponse state, EventBus bus) {
        this("org.eclipse.epp.logging.aeri.notifications.event.response", state, bus);
    }

    public ServerResponseNotification(String eventId, ServerResponse state, EventBus bus) {
        super(eventId, bus);
        this.state = state;
    }

    @Override
    public String getTitle() {
        String reportTitle = StringUtils.abbreviate((String)StringUtils.stripToEmpty((String)this.state.getReportTitle()), (int)40);
        switch (this.state.getResolution()) {
            case FIXED: {
                return MessageFormat.format("Fixed: {0}", reportTitle);
            }
            case NEEDINFO: {
                return MessageFormat.format("Your assistance is requested: {0}", reportTitle);
            }
            case NEW: 
            case UNCONFIRMED: {
                return MessageFormat.format("To be confirmed: {0}", reportTitle);
            }
            case WONTFIX: {
                return MessageFormat.format("Minor issue: {0}", reportTitle);
            }
            case INVALID: {
                return MessageFormat.format("Log message: {0}", reportTitle);
            }
        }
        return this.state.getResolution().name();
    }

    public String getLabel() {
        switch (this.state.getResolution()) {
            case FIXED: {
                return MessageFormat.format("Your issue appears to be fixed.", new Object[0]);
            }
            case INVALID: {
                return MessageFormat.format("Your report has been marked as a log message.", new Object[0]);
            }
            case NEEDINFO: {
                return MessageFormat.format("Your issue is known but further information is required.", new Object[0]);
            }
            case NEW: 
            case UNCONFIRMED: {
                return MessageFormat.format("Your report is now recorded.", new Object[0]);
            }
            case WONTFIX: {
                return MessageFormat.format("Your report has been marked as a minor issue.", new Object[0]);
            }
        }
        return "";
    }

    public String getDescription() {
        StringBuilder text = new StringBuilder();
        switch (this.state.getResolution()) {
            case FIXED: {
                if (!this.state.getBugUrl().isPresent()) break;
                text.append("Please visit the bug report for further details.");
                break;
            }
            case NEEDINFO: {
                if (this.state.getCommitterMessage().isPresent()) {
                    return (String)this.state.getCommitterMessage().get();
                }
                text.append("Please visit the incident and see if you can provide additional information.");
                break;
            }
            case NEW: 
            case UNCONFIRMED: {
                text.append(MessageFormat.format("It's not yet confirmed as a bug. Please visit your report and see if you can provide more information.", this.state.getReportTitle()));
                break;
            }
            case INVALID: 
            case WONTFIX: {
                text.append("If you think your report is actually an error, please visit your report and leave a comment.");
                break;
            }
        }
        if (this.state.getCommitterMessage().isPresent()) {
            text.append(MessageFormat.format("\nCommitter message: {0}", this.state.getCommitterMessage().get()));
        }
        text.append("\n\nThank you for your help!");
        return text.toString();
    }

    @Override
    public List<NoficationAction> getActions() {
        ArrayList actions = Lists.newArrayList();
        if (this.state.getBugId().isPresent()) {
            NoficationAction a = new NoficationAction("Visit #" + this.state.getBugId().get()){

                @Override
                public void execute() {
                    ServerResponseNotification.this.fireEvent(new Events.OpenUrlInBrowserRequest((String)ServerResponseNotification.this.state.getBugUrl().orNull()));
                }
            };
            actions.add(a);
        }
        NoficationAction a2 = new NoficationAction("Visit Submission"){

            @Override
            public void execute() {
                ServerResponseNotification.this.fireEvent(new Events.OpenUrlInBrowserRequest(ServerResponseNotification.this.state.getIncidentUrl()));
            }
        };
        actions.add(a2);
        return actions;
    }

    @Override
    public void unhandled() {
        this.fireEvent(new Events.ServerResponseNotificationTimedOut());
    }
}

