/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.notifications;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.Notification;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.PopupNotification;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Shells;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mylyn.commons.notifications.core.AbstractNotification;
import org.eclipse.mylyn.commons.notifications.core.NotificationSink;
import org.eclipse.mylyn.commons.notifications.core.NotificationSinkEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PopupNotificationSink
extends NotificationSink {
    private static final long DELAY_OPEN = 1000L;
    private static final boolean RUN_AS_SYSTEM_JOB = true;
    private final WeakHashMap<Object, Object> cancelledTokens = new WeakHashMap();
    private final Set<Notification> notifications = new HashSet<Notification>();
    private final Set<Notification> currentlyNotifying = Collections.synchronizedSet(this.notifications);
    private PopupNotification popup;
    private final Job openJob = new Job(""){

        protected IStatus run(IProgressMonitor monitor) {
            Display display = (Display)Shells.getDisplay().orNull();
            if (display == null || !Platform.isRunning()) {
                return Status.CANCEL_STATUS;
            }
            try {
                display.asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Notification notification;
                        if (PopupNotificationSink.this.popup != null && PopupNotificationSink.this.popup.getReturnCode() == 1 && (notification = PopupNotificationSink.this.popup.getNotification()).getToken() != null) {
                            PopupNotificationSink.this.cancelledTokens.put(notification.getToken(), null);
                        }
                        Iterator it = PopupNotificationSink.this.currentlyNotifying.iterator();
                        while (it.hasNext()) {
                            Notification notification2 = (Notification)((Object)it.next());
                            if (notification2.getToken() == null || !PopupNotificationSink.this.cancelledTokens.containsKey(notification2.getToken())) continue;
                            it.remove();
                        }
                        Class<PopupNotificationSink> clazz = PopupNotificationSink.class;
                        synchronized (PopupNotificationSink.class) {
                            if (PopupNotificationSink.this.currentlyNotifying.size() > 0) {
                                PopupNotificationSink.this.showPopup();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                });
            }
            finally {
                if (PopupNotificationSink.this.popup != null) {
                    this.schedule(PopupNotificationSink.this.popup.getDelayClose() / 2L);
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    };

    public PopupNotificationSink() {
        this.openJob.setSystem(true);
    }

    private void cleanNotified() {
        this.currentlyNotifying.clear();
    }

    public boolean isAnimationsEnabled() {
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        return store.getBoolean("ENABLE_ANIMATIONS");
    }

    public void notify(NotificationSinkEvent event) {
        for (AbstractNotification notification : event.getNotifications()) {
            if (!(notification instanceof Notification)) continue;
            this.currentlyNotifying.add((Notification)notification);
        }
        if (!this.openJob.cancel()) {
            try {
                this.openJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.openJob.schedule(1000L);
    }

    public void showPopup() {
        if (this.popup != null) {
            this.popup.close();
        }
        Shell shell = new Shell(PlatformUI.getWorkbench().getDisplay());
        this.popup = new PopupNotification(shell.getDisplay());
        this.popup.setFadingEnabled(this.isAnimationsEnabled());
        ArrayList<Notification> toDisplay = new ArrayList<Notification>(this.currentlyNotifying);
        Collections.sort(toDisplay);
        Notification notification = (Notification)((Object)toDisplay.get(0));
        this.popup.setNotification(notification);
        notification.setPopup(this.popup);
        this.cleanNotified();
        this.popup.setBlockOnOpen(false);
        this.popup.open();
    }
}

