/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.notifications;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.epp.internal.logging.aeri.ui.Events;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.Throwable;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.NoficationAction;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.Notification;

public class NewErrorNotification
extends Notification {
    private final ErrorReport report;

    public NewErrorNotification(ErrorReport report, EventBus bus) {
        super("org.eclipse.epp.logging.aeri.notifications.event.newReport", bus);
        this.report = report;
    }

    public String getDescription() {
        StringBuilder b = new StringBuilder();
        Throwable exception = this.report.getStatus().getException();
        if (exception != null) {
            String message = String.valueOf(exception.getClassName()) + ": " + (String)Optional.fromNullable((Object)exception.getMessage()).or((Object)"");
            b.append(StringUtils.abbreviate((String)message, (int)120));
        }
        b.append("\n\nDo you want to report this error?");
        return b.toString();
    }

    public String getLabel() {
        return "Message: " + this.report.getStatus().getMessage();
    }

    public ErrorReport getReport() {
        return this.report;
    }

    @Override
    public List<NoficationAction> getActions() {
        NoficationAction a1 = new NoficationAction("View Details"){

            @Override
            public void execute() {
                NewErrorNotification.this.fireEvent(new Events.NewReportShowDetailsRequest(NewErrorNotification.this.report));
            }
        };
        NoficationAction a2 = new NoficationAction("Send"){

            @Override
            public void execute() {
                NewErrorNotification.this.fireEvent(new Events.SendReportsRequest());
            }
        };
        return Lists.newArrayList((Object[])new NoficationAction[]{a1, a2});
    }

    @Override
    public String getTitle() {
        return "Error logged in " + this.getReport().getStatus().getPluginId();
    }

    @Override
    public void unhandled() {
        this.fireEvent(new Events.NewReportNotificationTimedOut(this.report));
    }
}

