/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.notifications;

import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.util.List;
import org.eclipse.epp.internal.logging.aeri.ui.INotificationService;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.ProblemStatus;
import org.eclipse.epp.internal.logging.aeri.ui.model.ServerResponse;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.BugIsFixedNotification;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.ConfigureNotification;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.NeedYourHelpNotification;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.NewErrorNotification;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.ServerResponseNotification;
import org.eclipse.mylyn.commons.notifications.ui.NotificationsUi;

public class MylynNotificationService
implements INotificationService {
    private EventBus bus;

    public MylynNotificationService(EventBus bus) {
        this.bus = bus;
    }

    @Override
    public void showWelcomeNotification() {
        ConfigureNotification notification = new ConfigureNotification(this.bus);
        NotificationsUi.getService().notify((List)Lists.newArrayList((Object[])new ConfigureNotification[]{notification}));
    }

    @Override
    public void showNewReportsAvailableNotification(ErrorReport e) {
        NotificationsUi.getService().notify((List)Lists.newArrayList((Object[])new NewErrorNotification[]{new NewErrorNotification(e, this.bus)}));
    }

    @Override
    public void showNewResponseNotification(ServerResponse state) {
        NotificationsUi.getService().notify((List)Lists.newArrayList((Object[])new ServerResponseNotification[]{new ServerResponseNotification(state, this.bus)}));
    }

    @Override
    public void showNeedInfoNotification(ErrorReport report, ProblemStatus status) {
        NotificationsUi.getService().notify((List)Lists.newArrayList((Object[])new NeedYourHelpNotification[]{new NeedYourHelpNotification(report, status, this.bus)}));
    }

    @Override
    public void showBugFixedInfo(ErrorReport report, ProblemStatus status) {
        NotificationsUi.getService().notify((List)Lists.newArrayList((Object[])new BugIsFixedNotification[]{new BugIsFixedNotification(report, status, this.bus)}));
    }
}

