/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.notifications;

import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.epp.internal.logging.aeri.ui.Events;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.ProblemStatus;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.NoficationAction;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.Notification;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class BugIsFixedNotification
extends Notification {
    private static Image IMG = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.epp.logging.aeri.ui", (String)"icons/obj16/database_refresh.png").createImage();
    private ProblemStatus state;
    private ErrorReport report;

    public BugIsFixedNotification(ErrorReport report, ProblemStatus state, EventBus bus) {
        super("org.eclipse.epp.logging.aeri.notifications.event.fixed", bus);
        this.state = state;
        this.report = report;
    }

    @Override
    public Image getNotificationImage() {
        return IMG;
    }

    @Override
    public String getTitle() {
        return "You hit an already fixed issue. Time to update?";
    }

    public String getLabel() {
        return String.format("'%s' was marked as FIXED.", StringUtils.abbreviate((String)this.report.getStatus().getMessage(), (int)60));
    }

    public String getDescription() {
        String message = (String)this.state.getMessage().or((Object)"Please visit Eclipse Bugzilla for details.");
        return StringUtils.abbreviate((String)message, (int)200);
    }

    @Override
    public List<NoficationAction> getActions() {
        ArrayList actions = Lists.newArrayList();
        NoficationAction a1 = new NoficationAction("View Details"){

            @Override
            public void execute() {
                BugIsFixedNotification.this.fireEvent(new Events.NewReportShowDetailsRequest(BugIsFixedNotification.this.report));
            }
        };
        actions.add(a1);
        if (this.state.hasBugId()) {
            NoficationAction a = new NoficationAction("Visit #" + this.state.getBugId()){

                @Override
                public void execute() {
                    BugIsFixedNotification.this.fireEvent(new Events.OpenUrlInBrowserRequest((String)BugIsFixedNotification.this.state.getBugUrl().get()));
                }
            };
            actions.add(a);
        }
        return actions;
    }

    @Override
    public void unhandled() {
        this.fireEvent(new Events.NeedInfoRequestdTimedOut());
    }
}

