/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.model.impl;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.UUID;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.epp.internal.logging.aeri.ui.model.Bundle;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.ModelFactory;
import org.eclipse.epp.internal.logging.aeri.ui.model.ModelPackage;
import org.eclipse.epp.internal.logging.aeri.ui.model.RememberSendAction;
import org.eclipse.epp.internal.logging.aeri.ui.model.SendAction;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.epp.internal.logging.aeri.ui.model.StackTraceElement;
import org.eclipse.epp.internal.logging.aeri.ui.model.Status;
import org.eclipse.epp.internal.logging.aeri.ui.model.Throwable;
import org.eclipse.epp.internal.logging.aeri.ui.model.impl.BundleImpl;
import org.eclipse.epp.internal.logging.aeri.ui.model.impl.ErrorReportImpl;
import org.eclipse.epp.internal.logging.aeri.ui.model.impl.SettingsImpl;
import org.eclipse.epp.internal.logging.aeri.ui.model.impl.StackTraceElementImpl;
import org.eclipse.epp.internal.logging.aeri.ui.model.impl.StatusImpl;
import org.eclipse.epp.internal.logging.aeri.ui.model.impl.ThrowableImpl;

public class ModelFactoryImpl
extends EFactoryImpl
implements ModelFactory {
    public static ModelFactory init() {
        try {
            ModelFactory theModelFactory = (ModelFactory)EPackage.Registry.INSTANCE.getEFactory("http://eclipse.org/epp/logging/aeri");
            if (theModelFactory != null) {
                return theModelFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ModelFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createErrorReport();
            }
            case 1: {
                return this.createBundle();
            }
            case 2: {
                return this.createStatus();
            }
            case 3: {
                return this.createThrowable();
            }
            case 4: {
                return this.createStackTraceElement();
            }
            case 5: {
                return this.createSettings();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createSendActionFromString(eDataType, initialValue);
            }
            case 7: {
                return this.createRememberSendActionFromString(eDataType, initialValue);
            }
            case 8: {
                return this.createUUIDFromString(eDataType, initialValue);
            }
            case 9: {
                return this.createListOfStringsFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertSendActionToString(eDataType, instanceValue);
            }
            case 7: {
                return this.convertRememberSendActionToString(eDataType, instanceValue);
            }
            case 8: {
                return this.convertUUIDToString(eDataType, instanceValue);
            }
            case 9: {
                return this.convertListOfStringsToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public ErrorReport createErrorReport() {
        ErrorReportImpl errorReport = new ErrorReportImpl();
        return errorReport;
    }

    @Override
    public Bundle createBundle() {
        BundleImpl bundle = new BundleImpl();
        return bundle;
    }

    @Override
    public Status createStatus() {
        StatusImpl status = new StatusImpl();
        return status;
    }

    @Override
    public Throwable createThrowable() {
        ThrowableImpl throwable = new ThrowableImpl();
        return throwable;
    }

    @Override
    public StackTraceElement createStackTraceElement() {
        StackTraceElementImpl stackTraceElement = new StackTraceElementImpl();
        return stackTraceElement;
    }

    @Override
    public Settings createSettings() {
        SettingsImpl settings = new SettingsImpl();
        return settings;
    }

    public SendAction createSendActionFromString(EDataType eDataType, String initialValue) {
        SendAction result = SendAction.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSendActionToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public RememberSendAction createRememberSendActionFromString(EDataType eDataType, String initialValue) {
        RememberSendAction result = RememberSendAction.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRememberSendActionToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public UUID createUUIDFromString(EDataType eDataType, String initialValue) {
        return (UUID)super.createFromString(eDataType, initialValue);
    }

    public String convertUUIDToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public List<String> createListOfStringsFromString(EDataType eDataType, String initialValue) {
        return Splitter.on((char)';').omitEmptyStrings().trimResults().splitToList((CharSequence)initialValue);
    }

    public String convertListOfStringsToString(EDataType eDataType, Object instanceValue) {
        return Joiner.on((String)";").skipNulls().join((Iterable)instanceValue);
    }

    @Override
    public ModelPackage getModelPackage() {
        return (ModelPackage)this.getEPackage();
    }

    @Deprecated
    public static ModelPackage getPackage() {
        return ModelPackage.eINSTANCE;
    }
}

