/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.model.Bundle;
import org.eclipse.epp.internal.logging.aeri.ui.model.Throwable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class LinkageErrorAnalyser {
    private final PackageAdmin packageAdmin;

    public LinkageErrorAnalyser() {
        this.packageAdmin = (PackageAdmin)this.getService(PackageAdmin.class).orNull();
    }

    @VisibleForTesting
    protected LinkageErrorAnalyser(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    protected <T> Optional<T> getService(Class<T> serviceClass) {
        if (LogMessages.BUNDLE == null) {
            return Optional.absent();
        }
        BundleContext context = LogMessages.BUNDLE.getBundleContext();
        if (context == null) {
            return Optional.absent();
        }
        ServiceReference reference = context.getServiceReference(serviceClass);
        if (reference == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)context.getService(reference));
    }

    public Optional<String> computeComment(List<Bundle> presentBundles, Throwable throwable) {
        if (this.packageAdmin == null) {
            return Optional.absent();
        }
        String problematicPackage = (String)LinkageErrorAnalyser.extractProblematicPackage(throwable).orNull();
        if (problematicPackage == null) {
            return Optional.absent();
        }
        HashSet presentBundlesSymbolicNames = Sets.newHashSet();
        for (Bundle presentBundle : presentBundles) {
            presentBundlesSymbolicNames.add(presentBundle.getName());
        }
        Object[] exportedPackages = this.packageAdmin.getExportedPackages(problematicPackage);
        if (ArrayUtils.isEmpty((Object[])exportedPackages)) {
            return Optional.absent();
        }
        HashMultimap exportersToImporters = HashMultimap.create();
        Object[] objectArray = exportedPackages;
        int n = exportedPackages.length;
        int n2 = 0;
        while (n2 < n) {
            Object exportedPackage = objectArray[n2];
            org.osgi.framework.Bundle exportingBundle = exportedPackage.getExportingBundle();
            if (this.isPresent(exportingBundle)) {
                org.osgi.framework.Bundle[] bundleArray = exportedPackage.getImportingBundles();
                int n3 = bundleArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    org.osgi.framework.Bundle importingBundle = bundleArray[n4];
                    if (this.isPresent(importingBundle) && presentBundlesSymbolicNames.contains(importingBundle.getSymbolicName())) {
                        exportersToImporters.put((Object)exportingBundle, (Object)importingBundle);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (exportersToImporters.isEmpty()) {
            return Optional.absent();
        }
        StringBuilder comment = new StringBuilder();
        comment.append("The problematic package '").append(problematicPackage).append("' may originate in the following bundles:\n");
        for (Map.Entry entry : exportersToImporters.asMap().entrySet()) {
            org.osgi.framework.Bundle exporter = (org.osgi.framework.Bundle)entry.getKey();
            Collection importers = (Collection)entry.getValue();
            comment.append("  ").append(exporter.getSymbolicName()).append(' ').append(exporter.getVersion()).append(", from which the following bundles present on the stack trace import it:\n");
            for (org.osgi.framework.Bundle importer : importers) {
                comment.append("    ").append(importer.getSymbolicName()).append(' ').append(importer.getVersion()).append('\n');
            }
        }
        return Optional.of((Object)comment.toString());
    }

    private boolean isPresent(org.osgi.framework.Bundle bundle) {
        switch (bundle.getState()) {
            case 4: 
            case 8: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    static Optional<String> extractProblematicPackage(Throwable throwable) {
        String message = throwable.getMessage();
        if (StringUtils.equals((CharSequence)"HIDDEN", (CharSequence)message)) {
            return Optional.absent();
        }
        if (NoClassDefFoundError.class.getName().equals(throwable.getClassName()) || LinkageError.class.getName().equals(throwable.getClassName())) {
            return LinkageErrorAnalyser.handleNoClassDefFoundErrorAndLinkageError(message);
        }
        if (ClassNotFoundException.class.getName().equals(throwable.getClassName())) {
            return LinkageErrorAnalyser.handleClassNotFoundException(message);
        }
        if (NoSuchMethodError.class.getName().equals(throwable.getClassName())) {
            return LinkageErrorAnalyser.handleMethodNotFoundException(message);
        }
        return Optional.absent();
    }

    private static Optional<String> handleNoClassDefFoundErrorAndLinkageError(String message) {
        int lastIndexOfSlash = message.lastIndexOf(47);
        if (lastIndexOfSlash < 0) {
            return Optional.absent();
        }
        String packageName = message.substring(0, lastIndexOfSlash).replace('/', '.');
        return Optional.of((Object)packageName);
    }

    private static Optional<String> handleClassNotFoundException(String message) {
        int lastIndexOfDot;
        int firstIndexOfSpace = message.indexOf(" ");
        if (firstIndexOfSpace >= 0) {
            message = message.substring(0, firstIndexOfSpace);
        }
        if ((lastIndexOfDot = message.lastIndexOf(46)) < 0) {
            return Optional.absent();
        }
        String packageName = message.substring(0, lastIndexOfDot);
        return Optional.of((Object)packageName);
    }

    private static Optional<String> handleMethodNotFoundException(String message) {
        String className = StringUtils.substringBeforeLast((String)message, (String)".");
        String packageName = StringUtils.substringBeforeLast((String)className, (String)".");
        return Optional.fromNullable((Object)packageName);
    }
}

