/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.log;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import org.eclipse.epp.internal.logging.aeri.ui.ExpiringReportHistory;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.log.ProblemsDatabaseService;
import org.eclipse.epp.internal.logging.aeri.ui.log.ReportHistory;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.ProblemStatus;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.epp.internal.logging.aeri.ui.model.Status;

public class ReportPredicates {

    public static class CompleteErrorReportPredicate
    implements Predicate<ErrorReport> {
        public boolean apply(ErrorReport report) {
            Status status = report.getStatus();
            return Objects.equal((Object)"org.eclipse.ui.monitoring", (Object)status.getPluginId()) ? !status.getChildren().isEmpty() : true;
        }
    }

    public static class ProblemDatabaseIgnoredPredicate
    implements Predicate<ErrorReport> {
        private ProblemsDatabaseService index;
        private Settings settings;

        public ProblemDatabaseIgnoredPredicate(ProblemsDatabaseService index, Settings settings) {
            this.index = index;
            this.settings = settings;
        }

        public boolean apply(ErrorReport report) {
            if (!this.settings.isSkipSimilarErrors()) {
                return true;
            }
            Optional<ProblemStatus> status = this.index.seen(report);
            return !status.isPresent() || ((ProblemStatus)status.get()).getAction() != ProblemStatus.RequiredAction.IGNORE;
        }
    }

    public static class ReportsHistoryPredicate
    implements Predicate<ErrorReport> {
        private ExpiringReportHistory history;
        private Settings settings;

        public ReportsHistoryPredicate(ExpiringReportHistory history, Settings settings) {
            this.history = history;
            this.settings = settings;
        }

        public boolean apply(ErrorReport report) {
            boolean seen;
            if (!this.settings.isSkipSimilarErrors()) {
                return true;
            }
            boolean bl = seen = this.history.seenExact(report) || this.history.seenSimilarTrace(report);
            if (!seen) {
                this.history.add(report);
            }
            return !seen;
        }
    }

    public static class UnseenErrorReportPredicate
    implements Predicate<ErrorReport> {
        private ReportHistory history;
        private Settings settings;

        public UnseenErrorReportPredicate(ReportHistory history, Settings settings) {
            this.history = history;
            this.settings = settings;
        }

        public boolean apply(ErrorReport report) {
            if (!this.settings.isSkipSimilarErrors()) {
                return true;
            }
            if (!this.history.isRunning()) {
                Logs.log(LogMessages.WARN_HISTORY_NOT_AVAILABLE);
                return true;
            }
            return !this.history.seenSimilar(report) && !this.history.seen(report);
        }
    }
}

