/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.log;

import com.google.common.base.Optional;
import com.google.common.io.Files;
import java.io.File;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.client.fluent.Content;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.log.ProblemsDatabaseService;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Proxies;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Zips;

public class ProblemsDatabaseUpdateJob
extends Job {
    private ProblemsDatabaseService service;
    private URL indexUrl;
    private Settings settings;

    public ProblemsDatabaseUpdateJob(ProblemsDatabaseService service, URL indexUrl, Settings settings) {
        super("Updating Error Reports Database");
        this.service = service;
        this.indexUrl = indexUrl;
        this.settings = settings;
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        progress.beginTask("Checking...", 3);
        try {
            String etag = (String)this.getEtag().orNull();
            progress.worked(1);
            if (etag == null) {
                IStatus iStatus = Logs.toStatus((Logs.ILogMessage)LogMessages.WARN_FAILED_TO_FETCH_PROBLEM_DB_ETAG, new Object[0]);
                return iStatus;
            }
            try {
                if (this.isLocalIndexOutdated(etag)) {
                    progress.subTask("Downloading new problem database");
                    File remoteIndexZip = this.downloadRemoteIndex();
                    progress.worked(1);
                    File tempDir = Files.createTempDir();
                    progress.subTask("Merging problem database");
                    Zips.unzip(remoteIndexZip, tempDir);
                    this.service.replaceContent(tempDir);
                    progress.worked(1);
                    this.settings.setProblemsZipEtag(etag);
                    FileUtils.deleteQuietly((File)tempDir);
                }
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.WARN_INDEX_UPDATE_FAILED, e);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private boolean isLocalIndexOutdated(String etag) {
        return !StringUtils.equals((CharSequence)this.settings.getProblemsZipEtag(), (CharSequence)etag);
    }

    private Optional<String> getEtag() {
        try {
            Executor executor = Executor.newInstance();
            URI target = this.indexUrl.toURI();
            Request request = Request.Head((URI)target).viaProxy((HttpHost)Proxies.getProxyHost(target).orNull());
            Response response = Proxies.proxyAuthentication(executor, target).execute(request);
            return Optional.fromNullable((Object)response.returnResponse().getFirstHeader("ETAG").getValue());
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_INDEX_UPDATE_FAILED, e);
            return Optional.absent();
        }
    }

    private File downloadRemoteIndex() throws Exception {
        Executor executor = Executor.newInstance();
        URI target = this.indexUrl.toURI();
        Request request = Request.Get((URI)target).viaProxy((HttpHost)Proxies.getProxyHost(target).orNull());
        Response response = Proxies.proxyAuthentication(executor, target).execute(request);
        Content content = response.returnContent();
        File temp = File.createTempFile("problems-index", ".zip");
        Files.write((byte[])content.asBytes(), (File)temp);
        return temp;
    }
}

