/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.log;

import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.eclipse.core.internal.net.ProxySelector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Proxies;
import org.eclipse.equinox.internal.p2.transport.ecf.RepositoryTransport;

public class NetworkCommunicationTestJob
extends Job {
    private static final String PROXY_TEST_URL = "http://download.eclipse.org/stats/technology/epp/logging/network-communication-test/proxy/authentication/";
    private static final String REQUEST_URL = "http://download.eclipse.org/stats/technology/epp/logging/network-communication-test/{0}/java-{1}/{2}-{3}/{4}-{5}/{6}/{7}-{8}/";
    private static final String APACHE_HTTP_REQUEST_PART = "apache";
    private static final String P2_HTTP_REQUEST_PART = "p2";
    private static final String UNKNOWN = "unknown";
    private static final String NO_PROXY_AUTHENTICATION = "none";
    private static final String BUGZILLA_URL = "https://bugs.eclipse.org/bugs/enter_bug.cgi?product=EPP&component=logging";

    public NetworkCommunicationTestJob() {
        super("Network Communication Test");
        this.setSystem(true);
        this.setPriority(50);
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        String javaVersion = NetworkCommunicationTestJob.getUrlSafeProperty("java.version");
        String operatingSystem = NetworkCommunicationTestJob.getUrlSafeProperty("os.name");
        String operatingSystemVersion = NetworkCommunicationTestJob.getUrlSafeProperty("os.version");
        String proxyProvider = ProxySelector.getDefaultProvider();
        try {
            URI proxyTestUri = new URL(PROXY_TEST_URL).toURI();
            String proxyHostConfigured = Proxies.getProxyHost(proxyTestUri).isPresent() ? "proxyHost" : "noProxyHost";
            String proxyUsernameConfigured = Proxies.getProxyUser(proxyTestUri).isPresent() ? "proxyUsername" : "noProxyUsername";
            String proxyPasswordConfigured = Proxies.getProxyPassword(proxyTestUri).isPresent() ? "proxyPassword" : "noProxyPassword";
            String authentication = this.getRequiredAuthentication(proxyTestUri, progress.newChild(1));
            this.doApacheHeadRequest(NetworkCommunicationTestJob.toUri(MessageFormat.format(REQUEST_URL, APACHE_HTTP_REQUEST_PART, javaVersion, operatingSystem, operatingSystemVersion, proxyProvider, authentication, proxyHostConfigured, proxyUsernameConfigured, proxyPasswordConfigured)), progress.newChild(1));
            this.doP2HeadRequest(NetworkCommunicationTestJob.toUri(MessageFormat.format(REQUEST_URL, P2_HTTP_REQUEST_PART, javaVersion, operatingSystem, operatingSystemVersion, proxyProvider, authentication, proxyHostConfigured, proxyUsernameConfigured, proxyPasswordConfigured)), progress.newChild(1));
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_NETWORK_COMMUNICATION_URL_PARSING_FAILED, e);
        }
        return Status.OK_STATUS;
    }

    private static URI toUri(String url) throws MalformedURLException, URISyntaxException {
        return new URL(url).toURI();
    }

    private String getRequiredAuthentication(URI uri, SubMonitor progress) {
        try {
            String authentication;
            Executor executor = Executor.newInstance();
            Request request = Request.Head((URI)uri).viaProxy((HttpHost)Proxies.getProxyHost(uri).orNull());
            Response response = executor.execute(request);
            String string = authentication = (String)response.handleResponse((ResponseHandler)new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws IOException {
                    Object[] headers = response.getHeaders("Proxy-Authenticate");
                    if (ArrayUtils.isEmpty((Object[])headers)) {
                        return NetworkCommunicationTestJob.NO_PROXY_AUTHENTICATION;
                    }
                    ArrayList authenticationSchemes = Lists.newArrayList();
                    int i = 0;
                    while (i < headers.length) {
                        Object header = headers[i];
                        String value = header.getValue();
                        if (value != null) {
                            authenticationSchemes.add(StringUtils.substringBefore((String)header.getValue(), (String)" "));
                        }
                        ++i;
                    }
                    return StringUtils.join((Iterable)authenticationSchemes, (char)';');
                }
            });
            return string;
        }
        catch (Exception e) {
            Logs.log(LogMessages.ERROR_ON_PROXY_AUTHENTICATION_TEST, e, uri);
            return UNKNOWN;
        }
        finally {
            progress.done();
        }
    }

    private void doApacheHeadRequest(URI uri, SubMonitor progress) {
        Executor executor = Executor.newInstance();
        Request request = Request.Head((URI)uri).viaProxy((HttpHost)Proxies.getProxyHost(uri).orNull());
        try {
            Response response = Proxies.proxyAuthentication(executor, uri).execute(request);
            HttpResponse httpResponse = response.returnResponse();
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != 404 || statusCode != 200) {
                StringBuilder sb = new StringBuilder();
                sb.append(System.lineSeparator());
                sb.append("Communication URL: ").append(uri).append(System.lineSeparator());
                sb.append("Response Code: ").append(statusCode).append(" - ").append(httpResponse.getStatusLine().getReasonPhrase()).append(System.lineSeparator());
                sb.append("Response Headers:").append(System.lineSeparator());
                Header[] headerArray = httpResponse.getAllHeaders();
                int n = headerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Header header = headerArray[n2];
                    sb.append(header.getName()).append(": ").append(header.getValue()).append(System.lineSeparator());
                    ++n2;
                }
                Logs.log(LogMessages.ERROR_ON_APACHE_HEAD_REQUEST, BUGZILLA_URL, sb);
            }
        }
        catch (Exception e) {
            Logs.log(LogMessages.ERROR_ON_APACHE_HEAD_REQUEST, e, BUGZILLA_URL, uri);
        }
        progress.done();
    }

    private void doP2HeadRequest(URI uri, SubMonitor progress) {
        try {
            RepositoryTransport transport = new RepositoryTransport();
            transport.getLastModified(uri, (IProgressMonitor)progress);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception e) {
            Logs.log(LogMessages.ERROR_ON_P2_HEAD_REQUEST, e, uri);
        }
    }

    private static String getUrlSafeProperty(String key) {
        try {
            return URLEncoder.encode(System.getProperty(key, UNKNOWN), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return UNKNOWN;
        }
    }
}

