/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.log;

import com.google.common.base.Predicate;
import com.google.common.eventbus.EventBus;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.logging.aeri.ui.Events;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.log.StandInStacktraceProvider;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.Reports;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;

public class LogListener
implements ILogListener {
    private StandInStacktraceProvider stacktraceProvider = new StandInStacktraceProvider();
    private Predicate<IStatus> statusFilters;
    private Predicate<ErrorReport> reportFilters;
    private EventBus bus;
    private Settings settings;

    public LogListener(Predicate<IStatus> statusFilters, Predicate<ErrorReport> reportFilters, Settings settings, EventBus bus) {
        this.statusFilters = statusFilters;
        this.reportFilters = reportFilters;
        this.settings = settings;
        this.bus = bus;
    }

    public void logging(IStatus status, String nouse) {
        try {
            if (!this.statusFilters.apply((Object)status)) {
                return;
            }
            ErrorReport report = this.createErrorReport(status);
            if (!this.reportFilters.apply((Object)report)) {
                return;
            }
            this.bus.post((Object)new Events.NewReportLogged(report));
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORTING_ERROR, e);
        }
    }

    private ErrorReport createErrorReport(IStatus status) {
        ErrorReport report = Reports.newErrorReport(status, this.settings);
        this.insertStandinStacktrace(report);
        Reports.guessInvolvedPlugins(report);
        Reports.insertLinkageErrorComment(report);
        return report;
    }

    private void insertStandinStacktrace(ErrorReport report) {
        this.stacktraceProvider.insertStandInStacktraceIfEmpty(report.getStatus(), this.settings);
    }
}

