/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui.log;

import java.net.URI;
import java.net.URL;
import org.apache.http.HttpHost;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.log.NetworkCommunicationTestJob;
import org.eclipse.epp.internal.logging.aeri.ui.model.RememberSendAction;
import org.eclipse.epp.internal.logging.aeri.ui.model.SendAction;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Proxies;

public class CheckServerAvailabilityJob
extends Job {
    private Settings settings;

    public CheckServerAvailabilityJob(Settings settings) {
        super("Checking Server Availability");
        this.settings = settings;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            URI target = new URL("https://dev.eclipse.org/recommenders/community/confess/problems.zip").toURI();
            Executor executor = Executor.newInstance();
            Request request = Request.Head((URI)target).viaProxy((HttpHost)Proxies.getProxyHost(target).orNull());
            Response response = Proxies.proxyAuthentication(executor, target).execute(request);
            int statusCode = response.returnResponse().getStatusLine().getStatusCode();
            if (statusCode != 200) {
                this.settings.setAction(SendAction.IGNORE);
                this.settings.setRememberSendAction(RememberSendAction.RESTART);
                Logs.log(LogMessages.INFO_SERVER_NOT_AVAILABLE);
                if (statusCode != 404) {
                    new NetworkCommunicationTestJob().schedule();
                }
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_SERVER_AVAILABILITY_CHECK_FAILED, e);
        }
        return Status.OK_STATUS;
    }
}

