/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.eventbus.EventBus;
import java.net.URI;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.logging.aeri.ui.Events;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.Reports;
import org.eclipse.epp.internal.logging.aeri.ui.model.ServerResponse;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Json;
import org.eclipse.epp.internal.logging.aeri.ui.utils.Proxies;

public class UploadJob
extends Job {
    private Executor executor;
    private ErrorReport event;
    private URI target;
    private Settings settings;
    private EventBus bus;

    public UploadJob(ErrorReport event, Settings settings, URI target, EventBus bus) {
        super(MessageFormat.format(Messages.UPLOADJOB_NAME, target));
        this.event = event;
        this.settings = settings;
        this.target = target;
        this.bus = bus;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(Messages.UPLOADJOB_TASKNAME, 1);
        try {
            this.executor = Executor.newInstance();
            String body = Reports.toJson(this.event, this.settings, false);
            StringEntity stringEntity = new StringEntity(body, ContentType.APPLICATION_OCTET_STREAM.withCharset(Charsets.UTF_8));
            GzipCompressingEntity entity = new GzipCompressingEntity((HttpEntity)stringEntity);
            Request request = Request.Post((URI)this.target).viaProxy((HttpHost)Proxies.getProxyHost(this.target).orNull()).body((HttpEntity)entity);
            Response response = Proxies.proxyAuthentication(this.executor, this.target).execute(request);
            HttpResponse httpResponse = response.returnResponse();
            String details = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
            int code = httpResponse.getStatusLine().getStatusCode();
            if (code >= 400) {
                MultiStatus multiStatus = new MultiStatus("org.eclipse.epp.logging.aeri.ui", 2, (IStatus[])new Status[]{new Status(2, "org.eclipse.epp.logging.aeri.ui", details)}, Messages.UPLOADJOB_FAILED, null);
                return multiStatus;
            }
            ServerResponse05 response05 = (ServerResponse05)Json.deserialize(details, ServerResponse05.class);
            ServerResponse result = new ServerResponse();
            result.setReportTitle(StringUtils.abbreviate((String)this.event.getStatus().getMessage(), (int)80));
            result.setIncidentId(response05.bugId);
            result.setIncidentUrl(response05.bugUrl);
            result.setResolution(this.tryParse(response05));
            result.setCommitterMessage(response05.information);
            this.bus.post((Object)new Events.ServerResponseShowRequest(result));
            Status status = new Status(0, "org.eclipse.epp.logging.aeri.ui", MessageFormat.format(Messages.UPLOADJOB_THANK_YOU, details));
            return status;
        }
        catch (Exception e) {
            Status status = new Status(2, "org.eclipse.epp.logging.aeri.ui", Messages.UPLOADJOB_FAILED, (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
    }

    private ServerResponse.ProblemResolution tryParse(ServerResponse05 state) {
        try {
            return ServerResponse.ProblemResolution.valueOf((String)state.getResolved().or((Object)ServerResponse.ProblemResolution.UNCONFIRMED.name()));
        }
        catch (Exception exception) {
            return ServerResponse.ProblemResolution.UNCONFIRMED;
        }
    }

    private static class ServerResponse05 {
        public static final String KEYWORD_NEEDINFO = "needinfo";
        public static final String[] EMPTY_STRINGS = new String[0];
        public static final String FIXED = "FIXED";
        public static final String ASSIGNED = "ASSIGNED";
        public static final String NOT_ECLIPSE = "NOT_ECLIPSE";
        public static final String INVALID = "INVALID";
        public static final String WONTFIX = "WONTFIX";
        public static final String WORKSFORME = "WORKSFORME";
        public static final String MOVED = "MOVED";
        public static final String DUPLICATE = "DUPLICATE";
        public static final String UNKNOWN = "UNKNOWN";
        public static final String CLOSED = "CLOSED";
        public static final String RESOLVED = "RESOLVED";
        public static final String NEW = "NEW";
        public static final String UNCONFIRMED = "UNCONFIRMED";
        private boolean created;
        private String bugId;
        private String bugUrl;
        private String status;
        private String resolved;
        private String information;
        private String[] keywords;

        private ServerResponse05() {
        }

        public boolean isCreated() {
            return this.created;
        }

        public Optional<String> getBugId() {
            return Optional.fromNullable((Object)this.bugId);
        }

        public Optional<String> getBugUrl() {
            return Optional.fromNullable((Object)this.bugUrl);
        }

        public Optional<String> getInformation() {
            return Optional.fromNullable((Object)this.information);
        }

        public Optional<String[]> getKeywords() {
            return Optional.fromNullable((Object)this.keywords);
        }

        public Optional<String> getResolved() {
            return Optional.fromNullable((Object)this.resolved);
        }

        public Optional<String> getStatus() {
            return Optional.fromNullable((Object)this.status);
        }
    }
}

