/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.eventbus.EventBus;
import java.io.File;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.internal.logging.aeri.ui.ExpiringReportHistory;
import org.eclipse.epp.internal.logging.aeri.ui.ReportingController;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ui.l10n.Logs;
import org.eclipse.epp.internal.logging.aeri.ui.log.CheckServerAvailabilityJob;
import org.eclipse.epp.internal.logging.aeri.ui.log.LogListener;
import org.eclipse.epp.internal.logging.aeri.ui.log.ProblemsDatabaseService;
import org.eclipse.epp.internal.logging.aeri.ui.log.ProblemsDatabaseUpdateJob;
import org.eclipse.epp.internal.logging.aeri.ui.log.ReportHistory;
import org.eclipse.epp.internal.logging.aeri.ui.log.ReportPredicates;
import org.eclipse.epp.internal.logging.aeri.ui.log.StatusPredicates;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.PreferenceInitializer;
import org.eclipse.epp.internal.logging.aeri.ui.model.Settings;
import org.eclipse.epp.internal.logging.aeri.ui.notifications.MylynNotificationService;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class Startup
implements IStartup {
    private ReportHistory history;
    private Settings settings;
    private ReportingController controller;
    private EventBus bus;
    private ExpiringReportHistory expiringReportHistory;
    private ProblemsDatabaseService problemsDb;

    public void earlyStartup() {
        new Job("Initializing Error Reporting System"){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Initializing error reporting", (int)8);
                progress.subTask("history");
                Startup.this.initializeHistory();
                progress.worked(1);
                progress.subTask("expiring history");
                Startup.this.initializeExpiringHistory();
                progress.worked(1);
                progress.subTask("problem database");
                Startup.this.initializeProblemsDatabase();
                progress.worked(1);
                progress.subTask("settings");
                Startup.this.initalizeSettings();
                progress.worked(1);
                progress.subTask("eventbus");
                Startup.this.initalizeEventBus();
                progress.worked(1);
                progress.subTask("controller");
                Startup.this.initalizeController();
                progress.worked(1);
                progress.subTask("log listener");
                Startup.this.initalizeLogListener();
                progress.worked(1);
                progress.subTask("jobs");
                Startup.this.scheduleJobs();
                progress.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void initializeHistory() {
        try {
            this.history = new ReportHistory();
            this.history.startAsync();
            PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                public boolean preShutdown(IWorkbench workbench, boolean forced) {
                    try {
                        Startup.this.history.stopAsync();
                        Startup.this.history.awaitTerminated();
                    }
                    catch (Exception exception) {
                        Logs.log(LogMessages.WARN_HISTORY_STOP_FAILED);
                    }
                    return true;
                }

                public void postShutdown(IWorkbench workbench) {
                }
            });
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_HISTORY_START_FAILED, e);
        }
    }

    private void initializeProblemsDatabase() {
        try {
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            IPath stateLocation = Platform.getStateLocation((Bundle)bundle);
            File indexDirectory = new File(stateLocation.toFile(), "remote-index");
            this.problemsDb = new ProblemsDatabaseService(indexDirectory);
            this.problemsDb.startAsync();
            PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

                public boolean preShutdown(IWorkbench workbench, boolean forced) {
                    try {
                        Startup.this.problemsDb.stopAsync();
                        Startup.this.problemsDb.awaitTerminated();
                    }
                    catch (Exception exception) {
                        Logs.log(LogMessages.WARN_INDEX_STOP_FAILED);
                    }
                    return true;
                }

                public void postShutdown(IWorkbench workbench) {
                }
            });
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_INDEX_START_FAILED, e);
        }
    }

    private void initializeExpiringHistory() {
        this.expiringReportHistory = new ExpiringReportHistory();
    }

    private void initalizeSettings() {
        this.settings = PreferenceInitializer.getDefault();
    }

    private void initalizeEventBus() {
        this.bus = new EventBus("Error Reporting Bus");
    }

    private void initalizeController() {
        this.controller = new ReportingController(this.bus, this.settings, new MylynNotificationService(this.bus), this.history, this.problemsDb);
        this.bus.register((Object)this.controller);
    }

    private void initalizeLogListener() {
        LogListener listener = Startup.createLogListener(this.settings, this.history, this.bus, this.expiringReportHistory, this.problemsDb);
        Platform.addLogListener((ILogListener)listener);
    }

    private void scheduleJobs() {
        try {
            URL indexZipUrl = new URL("https://dev.eclipse.org/recommenders/community/confess/problems.zip");
            new CheckServerAvailabilityJob(this.settings).schedule(TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS));
            new ProblemsDatabaseUpdateJob(this.problemsDb, indexZipUrl, this.settings).schedule(TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES));
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    @VisibleForTesting
    public static LogListener createLogListener(Settings settings, ReportHistory history, EventBus bus, ExpiringReportHistory expiringReportHistory, ProblemsDatabaseService serverProblemsStatusIndex) {
        Predicate statusFilters = Predicates.and((Predicate[])new Predicate[]{new StatusPredicates.ReporterNotDisabledPredicate(settings), new StatusPredicates.WhitelistedPluginIdPresentPredicate(settings), new StatusPredicates.SkipReportsAbsentPredicate(), new StatusPredicates.EclipseBuildIdPresentPredicate(), new StatusPredicates.ErrorStatusOnlyPredicate(), new StatusPredicates.WorkbenchRunningPredicate(PlatformUI.getWorkbench()), new StatusPredicates.HistoryReadyPredicate(history)});
        Predicate reportFilters = Predicates.and((Predicate[])new Predicate[]{new ReportPredicates.UnseenErrorReportPredicate(history, settings), new ReportPredicates.CompleteErrorReportPredicate(), new ReportPredicates.ReportsHistoryPredicate(expiringReportHistory, settings), new ReportPredicates.ProblemDatabaseIgnoredPredicate(serverProblemsStatusIndex, settings)});
        LogListener listener = new LogListener((Predicate<IStatus>)statusFilters, (Predicate<ErrorReport>)reportFilters, settings, bus);
        return listener;
    }
}

