/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ui;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.eclipse.epp.internal.logging.aeri.ui.model.ErrorReport;
import org.eclipse.epp.internal.logging.aeri.ui.model.Reports;
import org.eclipse.epp.internal.logging.aeri.ui.model.ServerResponse;

public class ExpiringReportHistory {
    private static final int EXPIRES_ON_IN_MINUTES = 60;
    private DelayQueue<HistoryEntry> history = new DelayQueue();

    public void add(ErrorReport report) {
        this.removeOutdated();
        HistoryEntry entry = new HistoryEntry(report, this.expiresOn());
        this.history.add(entry);
    }

    public void response(ErrorReport report, ServerResponse response) {
        for (HistoryEntry e : this.history) {
            if (!e.getReport().equals(report)) continue;
            e.setResponse(response);
        }
        HistoryEntry entry = new HistoryEntry(report, this.expiresOn());
        this.history.add(entry);
    }

    public ImmutableList<HistoryEntry> elements() {
        this.removeOutdated();
        return ImmutableList.copyOf(this.history);
    }

    private long expiresOn() {
        return System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(60L);
    }

    private void removeOutdated() {
        this.history.drainTo(Lists.newLinkedList());
    }

    public boolean seenExact(ErrorReport report) {
        String hash = Reports.exactIdentityHash(report);
        for (HistoryEntry e : this.elements()) {
            if (!e.getReportExactIndentityHash().equals(hash)) continue;
            return true;
        }
        return false;
    }

    public boolean seenSimilarTrace(ErrorReport report) {
        String hash = Reports.traceIdentityHash(report);
        for (HistoryEntry e : this.elements()) {
            if (!e.getReportTraceIdentityHash().equals(hash)) continue;
            return true;
        }
        return false;
    }

    public static class HistoryEntry
    implements Delayed {
        private long expiresOn;
        private final ErrorReport report;
        private final String reportExactIndentityHash;
        private final String reportTraceIdentityHash;
        private Optional<ServerResponse> response;

        public HistoryEntry(ErrorReport report, long expiresOn) {
            this.report = report;
            this.reportExactIndentityHash = Reports.exactIdentityHash(report);
            this.reportTraceIdentityHash = Reports.traceIdentityHash(report);
            this.expiresOn = expiresOn;
        }

        public String getReportExactIndentityHash() {
            return this.reportExactIndentityHash;
        }

        public String getReportTraceIdentityHash() {
            return this.reportTraceIdentityHash;
        }

        @Override
        public int compareTo(Delayed o) {
            return (int)(this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS));
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expiresOn - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        public void setResponse(ServerResponse response) {
            this.response = Optional.fromNullable((Object)response);
        }

        public Optional<ServerResponse> getResponse() {
            return this.response;
        }

        public ErrorReport getReport() {
            return this.report;
        }
    }
}

