/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;
import org.eclipse.recommenders.models.DownloadCallback;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelRepository
implements IModelRepository {
    private static final Logger LOG = LoggerFactory.getLogger(ModelRepository.class);
    private final RepositorySystem system;
    private final RepositorySystemSession defaultSession;
    private final RemoteRepository defaultRemoteRepo;
    private Authentication authentication;
    private Proxy proxy;
    private final Map<ModelCoordinate, Optional<File>> inProgressResolutions = Maps.newHashMap();

    public ModelRepository(File basedir, String remoteUrl) {
        this(ModelRepository.createRepositorySystem(), basedir, remoteUrl);
    }

    @VisibleForTesting
    public ModelRepository(Object system, File basedir, String remoteUrl) {
        this.system = (RepositorySystem)system;
        this.defaultSession = this.createDefaultSession(basedir);
        this.defaultRemoteRepo = this.createRemoteRepository(remoteUrl);
    }

    private static RepositorySystem createRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    private RepositorySystemSession createDefaultSession(File basedir) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(basedir);
        session.setLocalRepositoryManager(this.system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setArtifactDescriptorPolicy((ArtifactDescriptorPolicy)new SimpleArtifactDescriptorPolicy(1));
        session.setChecksumPolicy("fail");
        session.setConfigProperty("aether.connector.persistedChecksums", (Object)false);
        session.setConfigProperty("aether.artifactResolver.snapshotNormalization", (Object)false);
        session.setConfigProperty("aether.versionResolver.noCache", (Object)true);
        session.setConfigProperty("aether.updateCheckManager.sessionState", (Object)"bypass");
        return session;
    }

    private RemoteRepository createRemoteRepository(String url) {
        return new RemoteRepository.Builder("models", "default", url).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<File> getLocation(ModelCoordinate mc, boolean prefetch) {
        Map<ModelCoordinate, Optional<File>> map = this.inProgressResolutions;
        synchronized (map) {
            if (this.inProgressResolutions.containsKey(mc)) {
                return this.inProgressResolutions.get(mc);
            }
            RepositorySystemSession offlineSession = this.newOfflineSession();
            return this.resolveInternal(mc, offlineSession);
        }
    }

    @Override
    public Optional<File> resolve(ModelCoordinate mc, boolean force) {
        return this.resolve(mc, force, DownloadCallback.NULL);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Optional<File> resolve(ModelCoordinate mc, boolean force, DownloadCallback callback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Optional<File> resolveInternal(ModelCoordinate mc, RepositorySystemSession session) {
        try {
            Artifact coord = this.toSnapshotArtifact(mc);
            RemoteRepository remoteRepo = new RemoteRepository.Builder(this.defaultRemoteRepo).setAuthentication(this.authentication).setProxy(this.proxy).build();
            ArtifactRequest request = new ArtifactRequest(coord, Collections.singletonList(remoteRepo), null);
            ArtifactResult result = this.system.resolveArtifact(session, request);
            return Optional.of((Object)result.getArtifact().getFile());
        }
        catch (ArtifactResolutionException e) {
            if (!session.isOffline()) {
                LOG.warn("Failed to download {}", (Object)mc, (Object)e);
            }
            return Optional.absent();
        }
    }

    private RepositorySystemSession newOfflineSession() {
        DefaultRepositorySystemSession offlineSession = new DefaultRepositorySystemSession(this.defaultSession);
        offlineSession.setOffline(true);
        return offlineSession;
    }

    private DefaultRepositorySystemSession newOnlineSession(final DownloadCallback callback, boolean forceDownloads) {
        DefaultRepositorySystemSession onlineSession = new DefaultRepositorySystemSession(this.defaultSession);
        if (forceDownloads) {
            onlineSession.setUpdatePolicy("always");
            onlineSession.setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(0));
        } else {
            onlineSession.setUpdatePolicy("interval:" + TimeUnit.HOURS.toMinutes(1L));
            onlineSession.setResolutionErrorPolicy((ResolutionErrorPolicy)new SimpleResolutionErrorPolicy(3));
        }
        onlineSession.setTransferListener(new TransferListener(){

            public void transferInitiated(TransferEvent e) throws TransferCancelledException {
                callback.downloadInitiated(e.getResource().getResourceName());
            }

            public void transferStarted(TransferEvent e) throws TransferCancelledException {
                callback.downloadStarted(e.getResource().getResourceName());
            }

            public void transferProgressed(TransferEvent e) throws TransferCancelledException {
                callback.downloadProgressed(e.getResource().getResourceName(), e.getTransferredBytes(), e.getResource().getContentLength());
            }

            public void transferSucceeded(TransferEvent e) {
                callback.downloadSucceeded(e.getResource().getResourceName());
            }

            public void transferFailed(TransferEvent e) {
                callback.downloadFailed(e.getResource().getResourceName());
            }

            public void transferCorrupted(TransferEvent e) throws TransferCancelledException {
                callback.downloadCorrupted(e.getResource().getResourceName());
            }
        });
        return onlineSession;
    }

    @Beta
    public void setProxy(String type, String host, int port, String user, String pass) {
        Authentication proxyAuthentication = new AuthenticationBuilder().addUsername(user).addPassword(pass).build();
        this.proxy = type == null ? null : new Proxy(type, host, port, proxyAuthentication);
    }

    @Beta
    public void unsetProxy() {
        this.proxy = null;
    }

    @Beta
    public void setAuthentication(String user, String pass) {
        this.authentication = new AuthenticationBuilder().addUsername(user).addPassword(pass).build();
    }

    public String toString() {
        return this.defaultSession.getLocalRepository().getBasedir().toString();
    }

    private Artifact toSnapshotArtifact(ModelCoordinate mc) {
        return new DefaultArtifact(mc.getGroupId(), mc.getArtifactId(), mc.getClassifier(), mc.getExtension(), String.valueOf(mc.getVersion()) + "-SNAPSHOT");
    }
}

