/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.eclipse.recommenders.coordinates.Coordinates;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.Versions;

public final class ModelCoordinate {
    public static final ModelCoordinate UNKNOWN = new ModelCoordinate("unknown", "unknown", "unknown", "unknown", "0.0.0");
    public static final String HINT_REPOSITORY_URL = "repository.url";
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;
    private final String extension;
    private Map<String, String> hints = Maps.newHashMap();

    public ModelCoordinate(String groupId, String artifactId, String classifier, String extension, String version) {
        Checks.ensureIsTrue((boolean)Coordinates.isValidId((String)artifactId));
        Checks.ensureIsTrue((boolean)Coordinates.isValidId((String)extension));
        Checks.ensureIsTrue((boolean)Versions.isValidVersion((String)version));
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier;
        this.extension = extension;
        this.version = version;
    }

    public ModelCoordinate(String groupId, String artifactId, String classifier, String extension, String version, Map<String, String> hints) {
        this(groupId, artifactId, classifier, extension, version);
        this.hints = hints;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public Optional<String> getHint(String key) {
        return Optional.fromNullable((Object)this.hints.get(key));
    }

    public ImmutableMap<String, String> getHints() {
        return ImmutableMap.copyOf(this.hints);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.classifier, this.extension, this.hints);
    }

    public boolean equals(Object other) {
        if (!(other instanceof ModelCoordinate)) {
            return false;
        }
        ModelCoordinate that = (ModelCoordinate)other;
        return Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.version, that.version) && Objects.equals(this.classifier, that.classifier) && Objects.equals(this.extension, that.extension) && Objects.equals(this.hints, that.hints);
    }

    public String toString() {
        return Joiner.on((char)':').useForNull("").join((Object)this.getGroupId(), (Object)this.getArtifactId(), new Object[]{this.getClassifier(), this.getExtension(), this.getVersion()});
    }

    public static ModelCoordinate valueOf(String coord) {
        String[] split = coord.split(":");
        String gid = null;
        String aid = null;
        String ext = null;
        String clss = null;
        String vers = null;
        switch (split.length) {
            case 1: 
            case 2: {
                throw Throws.throwIllegalArgumentException((String)"Invalid coordinate format. It has only %d segments: %s", (Object[])new Object[]{split.length, coord});
            }
            case 3: {
                vers = split[2];
                break;
            }
            case 4: {
                clss = split[2];
                vers = split[3];
                break;
            }
            case 5: {
                clss = split[2];
                ext = split[3];
                vers = split[4];
                break;
            }
            default: {
                Throws.throwIllegalArgumentException((String)"Invalid coordinate format. It has only %d segments: %s", (Object[])new Object[]{split.length, coord});
            }
        }
        gid = split[0];
        aid = split[1];
        return new ModelCoordinate(gid, aid, clss, ext, vers);
    }
}

