/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.swt.SWT;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class EnvironmentUtils
extends AbstractUIPlugin {
    public static final String HOST_NAME = EnvironmentUtils.getHostName();
    public static final boolean DEVELOPER_HOST;
    public static final boolean IS_64BIT_OS;
    public static final boolean IS_WINDOWS;
    public static final boolean IS_UNIX;
    public static final boolean IS_MAC;
    public static final boolean IS_MAC_COCOA;
    public static final boolean IS_OS2;
    public static final boolean IS_LINUX;
    public static final boolean IS_MOTIF;
    private static final String OS_NAME_OSX_PREFIX = "Mac OS X";
    public static final boolean IS_MAC_10_6;
    private static final String OS_NAME_WINDOWS_PREFIX = "Windows";
    public static final boolean IS_WINDOWS_XP;
    public static final boolean IS_WINDOWS_VISTA;
    public static final boolean IS_WINDOWS_7;
    private static Float m_forcedJavaVersion;
    private static final String WBP_JAVA_VM_VENDOR = "wbp java.vm.vendor";
    private static final String WBP_TESTING_TIME = "wbp.testing.time";

    static {
        String host = HOST_NAME.toUpperCase(Locale.ENGLISH);
        DEVELOPER_HOST = "SCHEGLOV-KE".equals(host) || "SCHEGLOV-MACPRO".equals(host) || "SCHEGLOV-WIN".equals(host) || "SCHEGLOV".equals(host) || "MITIN-AA".equals(host) || "MITIN-AA-MAC".equals(host) || "SABLIN-AA".equals(host) || "FLANKER-WINDOWS".equals(host);
        IS_MAC_10_6 = EnvironmentUtils.getOSMatches(OS_NAME_OSX_PREFIX, "10.6");
        IS_WINDOWS_XP = EnvironmentUtils.getOSMatches(OS_NAME_WINDOWS_PREFIX, "5.1");
        IS_WINDOWS_VISTA = EnvironmentUtils.getOSMatches(OS_NAME_WINDOWS_PREFIX, "6.0");
        IS_WINDOWS_7 = EnvironmentUtils.getOSMatches(OS_NAME_WINDOWS_PREFIX, "6.1");
        if (SystemUtils.OS_NAME.startsWith(OS_NAME_WINDOWS_PREFIX)) {
            IS_WINDOWS = true;
            IS_UNIX = false;
            IS_MAC = false;
            IS_OS2 = false;
            IS_LINUX = false;
        } else if (SystemUtils.OS_NAME.startsWith("SunOS")) {
            IS_WINDOWS = false;
            IS_UNIX = true;
            IS_MAC = false;
            IS_OS2 = false;
            IS_LINUX = false;
        } else if (SystemUtils.OS_NAME.startsWith("Solaris")) {
            IS_WINDOWS = false;
            IS_UNIX = true;
            IS_MAC = false;
            IS_OS2 = false;
            IS_LINUX = false;
        } else if (SystemUtils.OS_NAME.startsWith("Linux")) {
            IS_WINDOWS = false;
            IS_UNIX = true;
            IS_MAC = false;
            IS_OS2 = false;
            IS_LINUX = true;
        } else if (SystemUtils.OS_NAME.startsWith("HP-UX")) {
            IS_WINDOWS = false;
            IS_UNIX = true;
            IS_MAC = false;
            IS_OS2 = false;
            IS_LINUX = false;
        } else if (SystemUtils.OS_NAME.startsWith("AIX")) {
            IS_WINDOWS = false;
            IS_UNIX = true;
            IS_MAC = false;
            IS_OS2 = false;
            IS_LINUX = false;
        } else if (SystemUtils.OS_NAME.startsWith("Irix")) {
            IS_WINDOWS = false;
            IS_UNIX = true;
            IS_MAC = false;
            IS_OS2 = false;
            IS_LINUX = false;
        } else if (SystemUtils.OS_NAME.startsWith("Digital Unix")) {
            IS_WINDOWS = false;
            IS_UNIX = true;
            IS_MAC = false;
            IS_OS2 = false;
            IS_LINUX = false;
        } else if (SystemUtils.OS_NAME.startsWith("OS/400")) {
            IS_WINDOWS = false;
            IS_UNIX = true;
            IS_MAC = false;
            IS_OS2 = false;
            IS_LINUX = false;
        } else if (SystemUtils.OS_NAME.startsWith("OS/2")) {
            IS_WINDOWS = false;
            IS_UNIX = false;
            IS_MAC = false;
            IS_OS2 = true;
            IS_LINUX = false;
        } else if (SystemUtils.OS_NAME.startsWith(OS_NAME_OSX_PREFIX)) {
            IS_WINDOWS = false;
            IS_UNIX = true;
            IS_MAC = true;
            IS_OS2 = false;
            IS_LINUX = false;
        } else if (SystemUtils.OS_NAME.startsWith("Mac")) {
            IS_WINDOWS = false;
            IS_UNIX = false;
            IS_MAC = true;
            IS_OS2 = false;
            IS_LINUX = false;
        } else {
            IS_WINDOWS = false;
            IS_UNIX = false;
            IS_MAC = false;
            IS_OS2 = false;
            IS_LINUX = false;
        }
        IS_MAC_COCOA = IS_MAC && "cocoa".equals(SWT.getPlatform());
        IS_MOTIF = "motif".equals(SWT.getPlatform());
        IS_64BIT_OS = SystemUtils.OS_ARCH.indexOf("64") != -1;
        m_forcedJavaVersion = null;
    }

    private static String getHostName() {
        String hostName = "";
        try {
            String[] names;
            hostName = InetAddress.getLocalHost().getHostName();
            String[] stringArray = names = StringUtils.split((String)hostName, (char)'.');
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (StringUtils.isNumeric((String)name)) {
                    return hostName;
                }
                ++n2;
            }
            hostName = names[0];
        }
        catch (UnknownHostException unknownHostException) {}
        return hostName;
    }

    private static boolean getOSMatches(String osNamePrefix, String osVersionPrefix) {
        if (SystemUtils.OS_NAME == null || SystemUtils.OS_VERSION == null) {
            return false;
        }
        return SystemUtils.OS_NAME.startsWith(osNamePrefix) && SystemUtils.OS_VERSION.startsWith(osVersionPrefix);
    }

    public static float getJavaVersion() {
        if (m_forcedJavaVersion != null) {
            return m_forcedJavaVersion.floatValue();
        }
        return SystemUtils.JAVA_VERSION_FLOAT;
    }

    public static void setForcedJavaVersion(Float version) {
        m_forcedJavaVersion = version;
    }

    public static boolean isJavaIBM() {
        return EnvironmentUtils.getTestSensetive_JAVA_VM_VENDOR().toUpperCase(Locale.ENGLISH).contains("IBM");
    }

    private static String getTestSensetive_JAVA_VM_VENDOR() {
        String forcedVendor = System.getProperty(WBP_JAVA_VM_VENDOR);
        if (forcedVendor != null) {
            return forcedVendor;
        }
        return SystemUtils.JAVA_VM_VENDOR;
    }

    public static void setForcedIBM(boolean forced) {
        if (forced) {
            System.setProperty(WBP_JAVA_VM_VENDOR, "Fake IBM");
        } else {
            System.clearProperty(WBP_JAVA_VM_VENDOR);
        }
    }

    public static boolean isTestingTime() {
        return "true".equals(System.getProperty(WBP_TESTING_TIME));
    }

    public static void setTestingTime(boolean value) {
        System.setProperty(WBP_TESTING_TIME, value ? "true" : "false");
    }
}

