/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.discovery.markers;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.internal.markers.MarkerUtils;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.internal.discovery.MavenDiscovery;
import org.eclipse.m2e.internal.discovery.MavenDiscoveryIcons;
import org.eclipse.m2e.internal.discovery.Messages;
import org.eclipse.m2e.internal.discovery.markers.MavenDiscoveryMarkerResolutionGenerator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class DiscoveryWizardProposal
extends WorkbenchMarkerResolution {
    public void run(IMarker marker) {
        try {
            IMarker[] fileMarkers = marker.getResource().findMarkers("org.eclipse.m2e.core.maven2Problem.lifecycleMapping", true, 2);
            this.run(fileMarkers, (IProgressMonitor)new NullProgressMonitor());
            return;
        }
        catch (CoreException coreException) {
            String type = marker.getAttribute("editor_hint", null);
            if ("not_covered_mojo_execution".equals(type)) {
                MavenDiscovery.launchWizard(Collections.EMPTY_LIST, Collections.singleton(MarkerUtils.getMojoExecution((IMarker)marker)), Collections.EMPTY_LIST, Collections.EMPTY_LIST);
            } else if ("unknown_lifecycle_id".equals(type)) {
                MavenDiscovery.launchWizard(Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.singleton(this.getLifecycleId(marker)), Collections.EMPTY_LIST);
            } else if ("missing_configurator".equals(type)) {
                MavenDiscovery.launchWizard(Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.singleton(this.getConfiguratorId(marker)));
            }
            return;
        }
    }

    public String getDescription() {
        return Messages.DiscoveryWizardProposal_description;
    }

    public Image getImage() {
        return MavenDiscoveryIcons.getImage(MavenDiscoveryIcons.QUICK_FIX_ICON);
    }

    public void run(IMarker[] markers, IProgressMonitor monitor) {
        ArrayList<String> lifecycleIds = new ArrayList<String>();
        ArrayList<String> packagingTypes = new ArrayList<String>();
        ArrayList<MojoExecutionKey> mojos = new ArrayList<MojoExecutionKey>();
        ArrayList<String> configuratorIds = new ArrayList<String>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            String type = marker.getAttribute("editor_hint", null);
            if ("not_covered_mojo_execution".equals(type)) {
                mojos.add(MarkerUtils.getMojoExecution((IMarker)marker));
            } else if ("unknown_lifecycle_id".equals(type)) {
                lifecycleIds.add(this.getLifecycleId(marker));
            } else if ("missing_configurator".equals(type)) {
                configuratorIds.add(this.getConfiguratorId(marker));
            }
            ++n2;
        }
        MavenDiscovery.launchWizard(packagingTypes, mojos, lifecycleIds, configuratorIds);
    }

    private String getLifecycleId(IMarker marker) {
        return marker.getAttribute("lifecyclePhase", null);
    }

    private String getConfiguratorId(IMarker marker) {
        return marker.getAttribute("configuratorId", null);
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        ArrayList<IMarker> handled = new ArrayList<IMarker>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (MavenDiscoveryMarkerResolutionGenerator.canResolve(marker)) {
                try {
                    IMarkerResolution[] cached = (IMarkerResolution[])marker.getResource().getSessionProperty(MavenDiscoveryMarkerResolutionGenerator.QUALIFIED);
                    if (cached == null || cached[0] != this) {
                        handled.add(marker);
                    }
                }
                catch (CoreException coreException) {
                    handled.add(marker);
                }
            }
            ++n2;
        }
        return handled.toArray(new IMarker[handled.size()]);
    }

    public String getLabel() {
        return Messages.DiscoveryWizardProposal_Label;
    }
}

