/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.optimizers.impl.refl.nodes;

import org.mvel2.ParserContext;
import org.mvel2.compiler.Accessor;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.optimizers.AccessorOptimizer;
import org.mvel2.optimizers.OptimizerFactory;

public class Union
implements Accessor {
    private final ParserContext pCtx;
    private Accessor accessor;
    private char[] nextExpr;
    private Accessor nextAccessor;

    public Union(Accessor accessor, char[] nextAccessor, ParserContext pCtx) {
        this.pCtx = pCtx;
        this.accessor = accessor;
        this.nextExpr = nextAccessor;
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        if (this.nextAccessor == null) {
            return this.get(ctx, elCtx, variableFactory);
        }
        return this.nextAccessor.getValue(this.get(ctx, elCtx, variableFactory), elCtx, variableFactory);
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        return this.nextAccessor.setValue(this.get(ctx, elCtx, variableFactory), elCtx, variableFactory, value);
    }

    private Object get(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        if (this.nextAccessor == null) {
            Object o = this.accessor.getValue(ctx, elCtx, variableFactory);
            AccessorOptimizer ao = OptimizerFactory.getDefaultAccessorCompiler(this.pCtx);
            Class ingress = this.accessor.getKnownEgressType();
            this.nextAccessor = ao.optimizeAccessor(this.nextExpr, o, elCtx, variableFactory, false, ingress);
            return ao.getResultOptPass();
        }
        return this.accessor.getValue(ctx, elCtx, variableFactory);
    }

    public Class getLeftIngressType() {
        return this.accessor.getKnownEgressType();
    }

    public Class getKnownEgressType() {
        return this.nextAccessor.getKnownEgressType();
    }
}

