/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.layout;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutPolicyUtils2 {
    public static <T extends JavaInfo> Command getPasteCommand(final JavaInfo existingHierarchyObject, final PasteRequest request, final Class<T> componentClass, final IPasteProcessor<T> processor) {
        final List mementos = (List)request.getMemento();
        return (Command)ExecutionUtils.runObjectLog((RunnableObjectEx)new RunnableObjectEx<Command>(){

            public Command runObject() throws Exception {
                final List components = Lists.newArrayList();
                for (JavaInfoMemento memento : mementos) {
                    JavaInfo javaInfo = memento.create(existingHierarchyObject);
                    if (componentClass.isAssignableFrom(((Object)((Object)javaInfo)).getClass())) {
                        components.add(javaInfo);
                        continue;
                    }
                    return null;
                }
                request.setObjects(components);
                return new EditCommand(existingHierarchyObject){

                    protected void executeEdit() throws Exception {
                        int i = 0;
                        while (i < components.size()) {
                            processor.process((JavaInfo)((Object)components.get(i)));
                            ((JavaInfoMemento)mementos.get(i)).apply();
                            ++i;
                        }
                    }
                };
            }
        }, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface IPasteProcessor<T extends JavaInfo> {
        public void process(T var1) throws Exception;
    }
}

