/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.apidocs.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.recommenders.apidocs.rcp.ApidocProvider;
import org.eclipse.recommenders.internal.apidocs.rcp.ApidocsPreferences;
import org.eclipse.recommenders.internal.apidocs.rcp.ApidocsViewUtils;
import org.eclipse.recommenders.internal.apidocs.rcp.DnDProviderTransfer;
import org.eclipse.recommenders.internal.apidocs.rcp.SubscriptionManager;
import org.eclipse.recommenders.internal.apidocs.rcp.l10n.Messages;
import org.eclipse.recommenders.rcp.JavaElementSelectionEvent;
import org.eclipse.recommenders.rcp.utils.PartListener2Adapter;
import org.eclipse.recommenders.rcp.utils.Selections;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApidocsView
extends ViewPart {
    private static final Logger LOG = LoggerFactory.getLogger(ApidocsView.class);
    public static final String ID = "org.eclipse.recommenders.apidocs.rcp.views.apidocs";
    private final EventBus workspaceBus;
    private final SubscriptionManager subscriptionManager;
    private final List<ApidocProvider> providers;
    private final ApidocsPreferences preferences;
    private static final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 0x200000L;
    private static final int MOVE_AFTER = 1;
    private static final int MOVE_BEFORE = 0;
    private final JavaElementLabelProvider labelProvider = new JavaElementLabelProvider((int)LABEL_FLAGS);
    private SashForm sash;
    private ScrolledComposite scrollable;
    private Composite content;
    private TableViewer viewer;
    private List<ApidocProvider> providerRanking;
    private boolean visible = true;
    private ApidocProvider activeProvider;
    private JavaElementSelectionEvent activeSelection;

    @Inject
    public ApidocsView(EventBus workspaceBus, SubscriptionManager subscriptionManager, List<ApidocProvider> providers, ApidocsPreferences preferences) {
        this.workspaceBus = workspaceBus;
        this.subscriptionManager = subscriptionManager;
        this.providers = providers;
        this.preferences = preferences;
        this.providerRanking = this.loadProviderRanking();
    }

    private List<ApidocProvider> loadProviderRanking() {
        LinkedList<ApidocProvider> providerRanking = new LinkedList<ApidocProvider>();
        Map<String, ApidocProvider> providerMap = this.fillProviderMap();
        List<String> providerIds = this.preferences.loadOrderedProviderIds();
        LinkedList<ApidocProvider> remainingProviders = new LinkedList<ApidocProvider>(this.providers);
        for (String providerName : providerIds) {
            ApidocProvider tmpProvider = providerMap.get(providerName);
            if (tmpProvider == null) continue;
            providerRanking.add(tmpProvider);
            remainingProviders.remove(tmpProvider);
        }
        providerRanking.addAll(remainingProviders);
        return providerRanking;
    }

    private Map<String, ApidocProvider> fillProviderMap() {
        HashMap<String, ApidocProvider> providerMap = new HashMap<String, ApidocProvider>();
        for (ApidocProvider provider : this.providers) {
            providerMap.put(provider.getId(), provider);
        }
        return providerMap;
    }

    @VisibleForTesting
    public void storeProviderRanking() {
        this.preferences.storeProviderRanking(this.providerRanking);
    }

    public void createPartControl(Composite parent) {
        this.createSash(parent);
        this.createProviderOverview();
        this.createContentArea();
        this.addVisibilityListener();
        this.applyUiPreferences();
        this.workspaceBus.register((Object)this);
    }

    private void createSash(Composite parent) {
        this.sash = new SashForm(parent, 65536);
        this.sash.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.sash.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ApidocsView.this.preferences.storeSashWeights(ApidocsView.this.sash.getWeights());
            }
        });
    }

    private void createProviderOverview() {
        this.viewer = new TableViewer((Composite)this.sash, 4);
        this.addDnDSupport();
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object first, Object second) {
                int indexFirst = ApidocsView.this.providerRanking.indexOf(first);
                int indexSecond = ApidocsView.this.providerRanking.indexOf(second);
                return indexFirst - indexSecond;
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ApidocProvider)element).getDescription().getName();
            }

            public Image getImage(Object element) {
                return ((ApidocProvider)element).getDescription().getImage();
            }
        });
        this.viewer.setInput(this.providers);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ApidocProvider newProvider = (ApidocProvider)Selections.getFirstSelected((ISelection)event.getSelection()).orNull();
                if (newProvider == ApidocsView.this.activeProvider) {
                    return;
                }
                ApidocsView.this.activeProvider = newProvider;
                Job job = new Job(Messages.JOB_UPDATING_APIDOCS){

                    protected IStatus run(IProgressMonitor monitor) {
                        ApidocsView.this.onJavaSelection(ApidocsView.this.activeSelection);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        });
        this.viewer.setSelection((ISelection)new StructuredSelection(Iterables.getFirst(this.providers, null)));
    }

    private void addDnDSupport() {
        Transfer[] transferTypes = new Transfer[]{DnDProviderTransfer.getInstance()};
        this.viewer.addDragSupport(2, transferTypes, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ApidocsView.this.viewer.getSelection();
                if (DnDProviderTransfer.getInstance().isSupportedType(event.dataType)) {
                    ApidocProvider selectedProvider = (ApidocProvider)selection.getFirstElement();
                    DnDProviderTransfer.getInstance().setExtdocProvider(selectedProvider);
                }
            }
        });
        this.viewer.addDropSupport(2, transferTypes, (DropTargetListener)new ViewerDropAdapter((Viewer)this.viewer){
            private int newIndex;
            private int currentFeedback;

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                return DnDProviderTransfer.getInstance().isSupportedType(transferType);
            }

            public void dragOver(DropTargetEvent event) {
                event.feedback = this.determineLocation(event) == 1 && this.isFirstProvider(event) ? 2 : 4;
                this.currentFeedback = event.feedback;
            }

            private boolean isFirstProvider(DropTargetEvent event) {
                return ApidocsView.this.providerRanking.indexOf(this.determineTarget(event)) == 0;
            }

            public void drop(DropTargetEvent event) {
                this.newIndex = event.item != null ? ApidocsView.this.providerRanking.indexOf(event.item.getData()) : ApidocsView.this.providerRanking.size() - 1;
                this.performDrop(event.data);
            }

            public boolean performDrop(Object data) {
                ApidocProvider provider = (ApidocProvider)data;
                int oldIndex = ApidocsView.this.providerRanking.indexOf(provider);
                if (this.currentFeedback == 4) {
                    ApidocsView.this.moveAfter(oldIndex, this.newIndex);
                } else {
                    ApidocsView.this.moveBefore(oldIndex, this.newIndex);
                }
                ApidocsView.this.storeProviderRanking();
                ApidocsView.this.viewer.refresh();
                return true;
            }
        });
    }

    private void move(int oldIndex, int newIndex, int moveStyle) {
        if (newIndex == oldIndex) {
            return;
        }
        if (newIndex < oldIndex) {
            ApidocProvider tmp = this.providerRanking.remove(oldIndex);
            this.providerRanking.add(newIndex + moveStyle, tmp);
        } else {
            ApidocProvider tmp = this.providerRanking.remove(oldIndex);
            this.providerRanking.add(newIndex - 1 + moveStyle, tmp);
        }
    }

    @VisibleForTesting
    public void moveAfter(int oldIndex, int newIndex) {
        this.move(oldIndex, newIndex, 1);
    }

    @VisibleForTesting
    public void moveBefore(int oldIndex, int newIndex) {
        this.move(oldIndex, newIndex, 0);
    }

    @VisibleForTesting
    public List<ApidocProvider> getProviderRanking() {
        return this.providerRanking;
    }

    private void createContentArea() {
        this.scrollable = new ScrolledComposite((Composite)this.sash, 768);
        this.scrollable.getVerticalBar().setIncrement(20);
        this.scrollable.setExpandHorizontal(true);
        this.scrollable.setExpandVertical(true);
        this.content = new Composite((Composite)this.scrollable, 0);
        this.content.setLayout((Layout)new GridLayout());
        this.content.setFont(JFaceResources.getDialogFont());
        ApidocsViewUtils.setInfoBackgroundColor((Control)this.content);
        this.scrollable.setContent((Control)this.content);
    }

    private void applyUiPreferences() {
        this.sash.setWeights(this.preferences.loadSashWeights());
    }

    private void addVisibilityListener() {
        this.getViewSite().getPage().addPartListener((IPartListener2)new PartListener2Adapter(){

            public void partHidden(IWorkbenchPartReference partRef) {
                if (this.isExtdocView(partRef)) {
                    ApidocsView.this.visible = false;
                }
            }

            public void partVisible(IWorkbenchPartReference partRef) {
                if (this.isExtdocView(partRef)) {
                    ApidocsView.this.visible = true;
                }
            }

            private boolean isExtdocView(IWorkbenchPartReference partRef) {
                return partRef.getPart(false) == ApidocsView.this;
            }
        });
    }

    public void dispose() {
        this.workspaceBus.unregister((Object)this);
        super.dispose();
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onJavaSelection(JavaElementSelectionEvent selection) {
        this.activeSelection = selection;
        if (this.visible && this.activeProvider != null && this.activeSelection != null) {
            try {
                this.disposeOldContentAndDisableRedrawOnContentArea();
                this.runProvider(selection);
                this.refreshAndEnableDrawContentArea();
            }
            catch (Exception e) {
                LOG.error("Exception during view update." + selection, (Throwable)e);
            }
        }
    }

    private void runProvider(JavaElementSelectionEvent selection) throws IllegalAccessException, InvocationTargetException {
        Optional<Method> opt = this.subscriptionManager.findSubscribedMethod(this.activeProvider, selection);
        if (opt.isPresent()) {
            Method method = (Method)opt.get();
            IJavaElement element = selection.getElement();
            method.invoke((Object)this.activeProvider, element, selection, this.content);
        }
    }

    private void refreshAndEnableDrawContentArea() {
        this.content.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Point size = ApidocsView.this.content.computeSize(-1, -1);
                ApidocsView.this.scrollable.setMinSize(size);
                ApidocsView.this.content.layout();
            }
        });
    }

    private void disposeOldContentAndDisableRedrawOnContentArea() {
        this.content.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ApidocsViewUtils.disposeChildren(ApidocsView.this.content);
                ApidocsView.this.addCurrentSelectionHeader();
            }
        });
    }

    private void addCurrentSelectionHeader() {
        String text;
        IJavaElement element = this.activeSelection.getElement();
        switch (element.getElementType()) {
            case 3: 
            case 4: {
                text = element.getElementName();
                break;
            }
            case 14: {
                text = JavaElementLabels.getElementLabel((IJavaElement)element, (long)163840L);
                break;
            }
            default: {
                text = JavaElementLabels.getElementLabel((IJavaElement)element, (long)LABEL_FLAGS);
            }
        }
        Composite header = new Composite(this.content, 0);
        ApidocsViewUtils.setInfoBackgroundColor((Control)header);
        header.setLayout((Layout)new GridLayout(2, false));
        Label img = new Label(header, 0);
        img.setImage(this.labelProvider.getImage((Object)element));
        ApidocsViewUtils.setInfoForegroundColor((Control)img);
        ApidocsViewUtils.setInfoBackgroundColor((Control)img);
        Label name = ApidocsViewUtils.createLabel(header, text, true);
        name.setFont(JFaceResources.getHeaderFont());
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }
}

