/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.ui;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.mylyn.internal.commons.ui.E4ThemeColor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class GradientColors {
    private final Display display;
    private Color titleText;
    private Color gradientBegin;
    private Color gradientEnd;
    private Color border;
    private final ResourceManager resourceManager;

    public GradientColors(Display display, ResourceManager resourceManager) {
        this.display = display;
        this.resourceManager = resourceManager;
        this.createColors();
    }

    private void createColors() {
        this.createBorderColor();
        this.createGradientColors();
        this.titleText = this.getColor(this.resourceManager, this.getSystemColor(17));
    }

    public Color getGradientBegin() {
        return this.gradientBegin;
    }

    public Color getGradientEnd() {
        return this.gradientEnd;
    }

    public Color getBorder() {
        return this.border;
    }

    public Color getTitleText() {
        return this.titleText;
    }

    private void createBorderColor() {
        RGB tbBorder = this.getSystemColor(31);
        RGB bg = this.getBackground();
        tbBorder = this.testTwoPrimaryColors(tbBorder, 179, 256) ? this.blend(tbBorder, bg, 70) : (this.testTwoPrimaryColors(tbBorder, 120, 180) ? this.blend(tbBorder, bg, 50) : this.blend(tbBorder, bg, 30));
        this.border = this.getColor(this.resourceManager, tbBorder);
    }

    private void createGradientColors() {
        RGB top;
        RGB bottom;
        RGB titleBg = this.getSystemColor(31);
        RGB bg = this.getBackground();
        if (this.testTwoPrimaryColors(titleBg, 179, 256)) {
            bottom = this.blend(titleBg, bg, 30);
            top = bg;
        } else if (this.testTwoPrimaryColors(titleBg, 120, 180)) {
            bottom = this.blend(titleBg, bg, 20);
            top = bg;
        } else {
            bottom = this.blend(titleBg, bg, 10);
            top = bg;
        }
        this.gradientBegin = this.getColor(this.resourceManager, top);
        this.gradientEnd = this.getColor(this.resourceManager, bottom);
    }

    private RGB blend(RGB c1, RGB c2, int ratio) {
        int r = this.blend(c1.red, c2.red, ratio);
        int g = this.blend(c1.green, c2.green, ratio);
        int b = this.blend(c1.blue, c2.blue, ratio);
        return new RGB(r, g, b);
    }

    private int blend(int v1, int v2, int ratio) {
        int b = (ratio * v1 + (100 - ratio) * v2) / 100;
        return Math.min(255, b);
    }

    private boolean testTwoPrimaryColors(RGB rgb, int from, int to) {
        int total = 0;
        if (this.testPrimaryColor(rgb.red, from, to)) {
            ++total;
        }
        if (this.testPrimaryColor(rgb.green, from, to)) {
            ++total;
        }
        if (this.testPrimaryColor(rgb.blue, from, to)) {
            ++total;
        }
        return total >= 2;
    }

    private boolean testPrimaryColor(int value, int from, int to) {
        return value > from && value < to;
    }

    private RGB getSystemColor(int code) {
        return this.getDisplay().getSystemColor(code).getRGB();
    }

    private Color getImpliedBackground() {
        return this.display.getSystemColor(25);
    }

    private Display getDisplay() {
        return this.display;
    }

    private Color getColor(ResourceManager manager, RGB rgb) {
        try {
            return manager.createColor(rgb);
        }
        catch (DeviceResourceException deviceResourceException) {
            return manager.getDevice().getSystemColor(2);
        }
    }

    private RGB getBackground() {
        RGB themeBg = this.getRGBFromTheme("background-color");
        RGB impliedBg = this.getImpliedBackground().getRGB();
        if (themeBg == null) {
            return impliedBg;
        }
        if (this.absoluteDifference(themeBg.red, impliedBg.red) < 40 || this.absoluteDifference(themeBg.blue, impliedBg.blue) < 40 || this.absoluteDifference(themeBg.green, impliedBg.green) < 40) {
            return impliedBg;
        }
        return themeBg;
    }

    private int absoluteDifference(int a, int b) {
        return Math.abs(a - b);
    }

    private RGB getRGBFromTheme(String value) {
        RGB themeColor;
        String backgroundColor;
        if (Platform.getBundle((String)"org.eclipse.e4.ui.css.swt.theme") != null && (backgroundColor = E4ThemeColor.getCssValueFromTheme(this.display, value)) != null && (themeColor = E4ThemeColor.getRGBFromCssString(backgroundColor)) != null) {
            return themeColor;
        }
        return null;
    }
}

