/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.ReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.ExecutableDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.TypeDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExecutableUtil {
    ExecutableUtil() {
    }

    static Collection<TypeParameterDeclaration> getFormalTypeParameters(EclipseDeclarationImpl executable, BaseProcessorEnv env) {
        if (executable == null || executable.kind() == EclipseMirrorObject.MirrorKind.ANNOTATION_ELEMENT) {
            return Collections.emptyList();
        }
        if (executable.kind() != EclipseMirrorObject.MirrorKind.METHOD && executable.kind() != EclipseMirrorObject.MirrorKind.CONSTRUCTOR) {
            throw new IllegalArgumentException("Executable is not a method " + executable.getClass().getName());
        }
        if (executable.isFromSource()) {
            MethodDeclaration methodAstNode = (MethodDeclaration)executable.getAstNode();
            if (methodAstNode == null) {
                return Collections.emptyList();
            }
            List typeParams = methodAstNode.typeParameters();
            ArrayList<TypeParameterDeclaration> result = new ArrayList<TypeParameterDeclaration>();
            for (TypeParameter typeParam : typeParams) {
                ITypeBinding typeBinding = typeParam.resolveBinding();
                if (typeBinding == null) {
                    throw new UnsupportedOperationException("cannot create a type parameter declaration without a binding");
                }
                TypeParameterDeclaration typeParamDecl = (TypeParameterDeclaration)((Object)Factory.createDeclaration((IBinding)typeBinding, env));
                if (typeParamDecl == null) continue;
                result.add(typeParamDecl);
            }
            return result;
        }
        if (!executable.isBindingBased()) {
            throw new IllegalStateException("binary executable without binding.");
        }
        IMethodBinding methodBinding = ((ExecutableDeclarationImpl)executable).getDeclarationBinding();
        ITypeBinding[] typeParams = methodBinding.getTypeParameters();
        if (typeParams == null || typeParams.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<TypeParameterDeclaration> result = new ArrayList<TypeParameterDeclaration>();
        ITypeBinding[] iTypeBindingArray = typeParams;
        int n = typeParams.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding typeVar = iTypeBindingArray[n2];
            TypeParameterDeclaration typeParamDecl = (TypeParameterDeclaration)((Object)Factory.createDeclaration((IBinding)typeVar, env));
            if (typeParamDecl != null) {
                result.add(typeParamDecl);
            }
            ++n2;
        }
        return result;
    }

    static Collection<ParameterDeclaration> getParameters(EclipseDeclarationImpl executable, BaseProcessorEnv env) {
        if (executable == null || executable.kind() == EclipseMirrorObject.MirrorKind.ANNOTATION_ELEMENT) {
            return Collections.emptyList();
        }
        if (executable.kind() != EclipseMirrorObject.MirrorKind.METHOD && executable.kind() != EclipseMirrorObject.MirrorKind.CONSTRUCTOR) {
            throw new IllegalArgumentException("Executable is not a method " + executable.getClass().getName());
        }
        if (executable.isFromSource()) {
            MethodDeclaration methodAstNode = (MethodDeclaration)executable.getAstNode();
            if (methodAstNode == null) {
                return Collections.emptyList();
            }
            List params = methodAstNode.parameters();
            if (params == null || params.size() == 0) {
                return Collections.emptyList();
            }
            ArrayList<ParameterDeclaration> result = new ArrayList<ParameterDeclaration>(params.size());
            int i = 0;
            int size = params.size();
            while (i < size) {
                SingleVariableDeclaration varDecl = (SingleVariableDeclaration)params.get(i);
                ParameterDeclaration param = Factory.createParameterDeclaration(varDecl, executable.getResource(), env);
                result.add(param);
                ++i;
            }
            return result;
        }
        if (!executable.isBindingBased()) {
            throw new IllegalStateException("binary executable without binding.");
        }
        ExecutableDeclarationImpl impl = (ExecutableDeclarationImpl)executable;
        IMethodBinding methodBinding = impl.getDeclarationBinding();
        ITypeBinding[] paramTypes = methodBinding.getParameterTypes();
        if (paramTypes == null || paramTypes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ParameterDeclaration> result = new ArrayList<ParameterDeclaration>(paramTypes.length);
        int i = 0;
        while (i < paramTypes.length) {
            ITypeBinding type = paramTypes[i];
            ParameterDeclaration param = Factory.createParameterDeclaration(impl, i, type, env);
            result.add(param);
            ++i;
        }
        return result;
    }

    static Collection<ReferenceType> getThrownTypes(EclipseDeclarationImpl executable, BaseProcessorEnv env) {
        if (executable == null || executable.kind() == EclipseMirrorObject.MirrorKind.ANNOTATION_ELEMENT) {
            return Collections.emptyList();
        }
        if (executable.kind() != EclipseMirrorObject.MirrorKind.METHOD && executable.kind() != EclipseMirrorObject.MirrorKind.CONSTRUCTOR) {
            throw new IllegalArgumentException("Executable is not a method " + executable.getClass().getName());
        }
        if (executable.isFromSource()) {
            MethodDeclaration methodAstNode = (MethodDeclaration)executable.getAstNode();
            if (methodAstNode == null) {
                return Collections.emptyList();
            }
            List exceptions = methodAstNode.thrownExceptionTypes();
            if (exceptions == null || exceptions.size() == 0) {
                return Collections.emptyList();
            }
            ArrayList<ReferenceType> results = new ArrayList<ReferenceType>(4);
            for (Type exception : exceptions) {
                ITypeBinding eType = exception.resolveBinding();
                DeclaredType refType = eType == null || eType.isRecovered() ? Factory.createErrorClassType(exception.toString()) : Factory.createReferenceType(eType, env);
                results.add(refType);
            }
            return results;
        }
        if (!executable.isBindingBased()) {
            throw new IllegalStateException("binary executable without binding.");
        }
        ExecutableDeclarationImpl impl = (ExecutableDeclarationImpl)executable;
        IMethodBinding methodBinding = impl.getDeclarationBinding();
        ITypeBinding[] exceptions = methodBinding.getExceptionTypes();
        ArrayList<ReferenceType> results = new ArrayList<ReferenceType>(4);
        ITypeBinding[] iTypeBindingArray = exceptions;
        int n = exceptions.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding exception = iTypeBindingArray[n2];
            TypeDeclarationImpl mirrorDecl = Factory.createReferenceType(exception, env);
            if (mirrorDecl != null) {
                results.add(mirrorDecl);
            }
            ++n2;
        }
        return results;
    }
}

