/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.syncinfo;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.ResourceVariantByteStore;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class CVSBaseResourceVariantTree
extends ResourceVariantByteStore {
    public void dispose() {
    }

    public byte[] getBytes(IResource resource) throws TeamException {
        if (resource.getType() == 1) {
            byte[] bytes = EclipseSynchronizer.getInstance().getSyncBytes(resource);
            if (bytes != null) {
                if (ResourceSyncInfo.isDeletion(bytes)) {
                    bytes = ResourceSyncInfo.convertFromDeletion(bytes);
                } else if (ResourceSyncInfo.isAddition(bytes)) {
                    bytes = null;
                }
            }
            return bytes;
        }
        FolderSyncInfo info = EclipseSynchronizer.getInstance().getFolderSync((IContainer)resource);
        if (info == null) {
            return null;
        }
        return info.getBytes();
    }

    public boolean isVariantKnown(IResource resource) throws TeamException {
        return this.getBytes(resource) != null;
    }

    public boolean flushBytes(IResource resource, int depth) throws TeamException {
        throw new UnsupportedOperationException();
    }

    public boolean setBytes(IResource resource, byte[] bytes) throws TeamException {
        throw new UnsupportedOperationException();
    }

    public boolean deleteBytes(IResource resource) throws TeamException {
        throw new UnsupportedOperationException();
    }

    public IResource[] members(IResource resource) throws TeamException {
        if (resource.getType() == 1) {
            return new IResource[0];
        }
        return EclipseSynchronizer.getInstance().members((IContainer)resource);
    }
}

