/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.spdy;

import com.squareup.okhttp.internal.BitArray;
import com.squareup.okhttp.internal.okio.BufferedSource;
import com.squareup.okhttp.internal.okio.ByteString;
import com.squareup.okhttp.internal.okio.OkBuffer;
import com.squareup.okhttp.internal.okio.Okio;
import com.squareup.okhttp.internal.okio.Source;
import com.squareup.okhttp.internal.spdy.Header;
import com.squareup.okhttp.internal.spdy.Huffman;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class HpackDraft05 {
    private static final int PREFIX_6_BITS = 63;
    private static final int PREFIX_7_BITS = 127;
    private static final Header[] STATIC_HEADER_TABLE = new Header[]{new Header(Header.TARGET_AUTHORITY, ""), new Header(Header.TARGET_METHOD, "GET"), new Header(Header.TARGET_METHOD, "POST"), new Header(Header.TARGET_PATH, "/"), new Header(Header.TARGET_PATH, "/index.html"), new Header(Header.TARGET_SCHEME, "http"), new Header(Header.TARGET_SCHEME, "https"), new Header(Header.RESPONSE_STATUS, "200"), new Header(Header.RESPONSE_STATUS, "500"), new Header(Header.RESPONSE_STATUS, "404"), new Header(Header.RESPONSE_STATUS, "403"), new Header(Header.RESPONSE_STATUS, "400"), new Header(Header.RESPONSE_STATUS, "401"), new Header("accept-charset", ""), new Header("accept-encoding", ""), new Header("accept-language", ""), new Header("accept-ranges", ""), new Header("accept", ""), new Header("access-control-allow-origin", ""), new Header("age", ""), new Header("allow", ""), new Header("authorization", ""), new Header("cache-control", ""), new Header("content-disposition", ""), new Header("content-encoding", ""), new Header("content-language", ""), new Header("content-length", ""), new Header("content-location", ""), new Header("content-range", ""), new Header("content-type", ""), new Header("cookie", ""), new Header("date", ""), new Header("etag", ""), new Header("expect", ""), new Header("expires", ""), new Header("from", ""), new Header("host", ""), new Header("if-match", ""), new Header("if-modified-since", ""), new Header("if-none-match", ""), new Header("if-range", ""), new Header("if-unmodified-since", ""), new Header("last-modified", ""), new Header("link", ""), new Header("location", ""), new Header("max-forwards", ""), new Header("proxy-authenticate", ""), new Header("proxy-authorization", ""), new Header("range", ""), new Header("referer", ""), new Header("refresh", ""), new Header("retry-after", ""), new Header("server", ""), new Header("set-cookie", ""), new Header("strict-transport-security", ""), new Header("transfer-encoding", ""), new Header("user-agent", ""), new Header("vary", ""), new Header("via", ""), new Header("www-authenticate", "")};
    private static final Map<ByteString, Integer> NAME_TO_FIRST_INDEX = HpackDraft05.nameToFirstIndex();

    private HpackDraft05() {
    }

    private static Map<ByteString, Integer> nameToFirstIndex() {
        LinkedHashMap<ByteString, Integer> result = new LinkedHashMap<ByteString, Integer>(STATIC_HEADER_TABLE.length);
        for (int i = 0; i < STATIC_HEADER_TABLE.length; ++i) {
            if (result.containsKey(HpackDraft05.STATIC_HEADER_TABLE[i].name)) continue;
            result.put(HpackDraft05.STATIC_HEADER_TABLE[i].name, i);
        }
        return Collections.unmodifiableMap(result);
    }

    static final class Writer {
        private final OkBuffer out;

        Writer(OkBuffer out) {
            this.out = out;
        }

        void writeHeaders(List<Header> headerBlock) throws IOException {
            int size = headerBlock.size();
            for (int i = 0; i < size; ++i) {
                ByteString name = headerBlock.get((int)i).name;
                Integer staticIndex = (Integer)NAME_TO_FIRST_INDEX.get(name);
                if (staticIndex != null) {
                    this.writeInt(staticIndex + 1, 63, 64);
                    this.writeByteString(headerBlock.get((int)i).value);
                    continue;
                }
                this.out.writeByte(64);
                this.writeByteString(name);
                this.writeByteString(headerBlock.get((int)i).value);
            }
        }

        void writeInt(int value, int prefixMask, int bits) throws IOException {
            if (value < prefixMask) {
                this.out.writeByte(bits | value);
                return;
            }
            this.out.writeByte(bits | prefixMask);
            value -= prefixMask;
            while (value >= 128) {
                int b = value & 0x7F;
                this.out.writeByte(b | 0x80);
                value >>>= 7;
            }
            this.out.writeByte(value);
        }

        void writeByteString(ByteString data) throws IOException {
            this.writeInt(data.size(), 127, 0);
            this.out.write(data);
        }
    }

    static final class Reader {
        private final Huffman.Codec huffmanCodec;
        private final List<Header> emittedHeaders = new ArrayList<Header>();
        private final BufferedSource source;
        private int maxHeaderTableByteCount;
        Header[] headerTable = new Header[8];
        int nextHeaderIndex = this.headerTable.length - 1;
        int headerCount = 0;
        BitArray referencedHeaders = new BitArray.FixedCapacity();
        BitArray emittedReferencedHeaders = new BitArray.FixedCapacity();
        int headerTableByteCount = 0;

        Reader(boolean client, int maxHeaderTableByteCount, Source source) {
            this.huffmanCodec = client ? Huffman.Codec.RESPONSE : Huffman.Codec.REQUEST;
            this.maxHeaderTableByteCount = maxHeaderTableByteCount;
            this.source = Okio.buffer(source);
        }

        int maxHeaderTableByteCount() {
            return this.maxHeaderTableByteCount;
        }

        void maxHeaderTableByteCount(int newMaxHeaderTableByteCount) {
            this.maxHeaderTableByteCount = newMaxHeaderTableByteCount;
            if (this.maxHeaderTableByteCount < this.headerTableByteCount) {
                if (this.maxHeaderTableByteCount == 0) {
                    this.clearHeaderTable();
                } else {
                    this.evictToRecoverBytes(this.headerTableByteCount - this.maxHeaderTableByteCount);
                }
            }
        }

        private void clearHeaderTable() {
            this.clearReferenceSet();
            Arrays.fill(this.headerTable, null);
            this.nextHeaderIndex = this.headerTable.length - 1;
            this.headerCount = 0;
            this.headerTableByteCount = 0;
        }

        private int evictToRecoverBytes(int bytesToRecover) {
            int entriesToEvict = 0;
            if (bytesToRecover > 0) {
                for (int j = this.headerTable.length - 1; j >= this.nextHeaderIndex && bytesToRecover > 0; --j) {
                    bytesToRecover -= this.headerTable[j].hpackSize;
                    this.headerTableByteCount -= this.headerTable[j].hpackSize;
                    --this.headerCount;
                    ++entriesToEvict;
                }
                this.referencedHeaders.shiftLeft(entriesToEvict);
                this.emittedReferencedHeaders.shiftLeft(entriesToEvict);
                System.arraycopy(this.headerTable, this.nextHeaderIndex + 1, this.headerTable, this.nextHeaderIndex + 1 + entriesToEvict, this.headerCount);
                this.nextHeaderIndex += entriesToEvict;
            }
            return entriesToEvict;
        }

        void readHeaders() throws IOException {
            while (!this.source.exhausted()) {
                int index;
                int b = this.source.readByte() & 0xFF;
                if (b == 128) {
                    this.clearReferenceSet();
                    continue;
                }
                if ((b & 0x80) == 128) {
                    index = this.readInt(b, 127);
                    this.readIndexedHeader(index - 1);
                    continue;
                }
                if (b == 64) {
                    this.readLiteralHeaderWithoutIndexingNewName();
                    continue;
                }
                if ((b & 0x40) == 64) {
                    index = this.readInt(b, 63);
                    this.readLiteralHeaderWithoutIndexingIndexedName(index - 1);
                    continue;
                }
                if (b == 0) {
                    this.readLiteralHeaderWithIncrementalIndexingNewName();
                    continue;
                }
                if ((b & 0xC0) == 0) {
                    index = this.readInt(b, 63);
                    this.readLiteralHeaderWithIncrementalIndexingIndexedName(index - 1);
                    continue;
                }
                throw new AssertionError((Object)("unhandled byte: " + Integer.toBinaryString(b)));
            }
        }

        private void clearReferenceSet() {
            this.referencedHeaders.clear();
            this.emittedReferencedHeaders.clear();
        }

        void emitReferenceSet() {
            for (int i = this.headerTable.length - 1; i != this.nextHeaderIndex; --i) {
                if (!this.referencedHeaders.get(i) || this.emittedReferencedHeaders.get(i)) continue;
                this.emittedHeaders.add(this.headerTable[i]);
            }
        }

        List<Header> getAndReset() {
            ArrayList<Header> result = new ArrayList<Header>(this.emittedHeaders);
            this.emittedHeaders.clear();
            this.emittedReferencedHeaders.clear();
            return result;
        }

        private void readIndexedHeader(int index) {
            if (this.isStaticHeader(index)) {
                Header staticEntry = STATIC_HEADER_TABLE[index - this.headerCount];
                if (this.maxHeaderTableByteCount == 0) {
                    this.emittedHeaders.add(staticEntry);
                } else {
                    this.insertIntoHeaderTable(-1, staticEntry);
                }
            } else {
                int headerTableIndex = this.headerTableIndex(index);
                if (!this.referencedHeaders.get(headerTableIndex)) {
                    this.emittedHeaders.add(this.headerTable[headerTableIndex]);
                    this.emittedReferencedHeaders.set(headerTableIndex);
                }
                this.referencedHeaders.toggle(headerTableIndex);
            }
        }

        private int headerTableIndex(int index) {
            return this.nextHeaderIndex + 1 + index;
        }

        private void readLiteralHeaderWithoutIndexingIndexedName(int index) throws IOException {
            ByteString name = this.getName(index);
            ByteString value = this.readByteString(false);
            this.emittedHeaders.add(new Header(name, value));
        }

        private void readLiteralHeaderWithoutIndexingNewName() throws IOException {
            ByteString name = this.readByteString(true);
            ByteString value = this.readByteString(false);
            this.emittedHeaders.add(new Header(name, value));
        }

        private void readLiteralHeaderWithIncrementalIndexingIndexedName(int nameIndex) throws IOException {
            ByteString name = this.getName(nameIndex);
            ByteString value = this.readByteString(false);
            this.insertIntoHeaderTable(-1, new Header(name, value));
        }

        private void readLiteralHeaderWithIncrementalIndexingNewName() throws IOException {
            ByteString name = this.readByteString(true);
            ByteString value = this.readByteString(false);
            this.insertIntoHeaderTable(-1, new Header(name, value));
        }

        private ByteString getName(int index) {
            if (this.isStaticHeader(index)) {
                return STATIC_HEADER_TABLE[index - this.headerCount].name;
            }
            return this.headerTable[this.headerTableIndex((int)index)].name;
        }

        private boolean isStaticHeader(int index) {
            return index >= this.headerCount;
        }

        private void insertIntoHeaderTable(int index, Header entry) {
            int delta = entry.hpackSize;
            if (index != -1) {
                delta -= this.headerTable[this.headerTableIndex((int)index)].hpackSize;
            }
            if (delta > this.maxHeaderTableByteCount) {
                this.clearHeaderTable();
                this.emittedHeaders.add(entry);
                return;
            }
            int bytesToRecover = this.headerTableByteCount + delta - this.maxHeaderTableByteCount;
            int entriesEvicted = this.evictToRecoverBytes(bytesToRecover);
            if (index == -1) {
                if (this.headerCount + 1 > this.headerTable.length) {
                    Header[] doubled = new Header[this.headerTable.length * 2];
                    System.arraycopy(this.headerTable, 0, doubled, this.headerTable.length, this.headerTable.length);
                    if (doubled.length == 64) {
                        this.referencedHeaders = ((BitArray.FixedCapacity)this.referencedHeaders).toVariableCapacity();
                        this.emittedReferencedHeaders = ((BitArray.FixedCapacity)this.emittedReferencedHeaders).toVariableCapacity();
                    }
                    this.referencedHeaders.shiftLeft(this.headerTable.length);
                    this.emittedReferencedHeaders.shiftLeft(this.headerTable.length);
                    this.nextHeaderIndex = this.headerTable.length - 1;
                    this.headerTable = doubled;
                }
                index = this.nextHeaderIndex--;
                this.referencedHeaders.set(index);
                this.headerTable[index] = entry;
                ++this.headerCount;
            } else {
                index += this.headerTableIndex(index) + entriesEvicted;
                this.referencedHeaders.set(index);
                this.headerTable[index] = entry;
            }
            this.headerTableByteCount += delta;
        }

        private int readByte() throws IOException {
            return this.source.readByte() & 0xFF;
        }

        int readInt(int firstByte, int prefixMask) throws IOException {
            int b;
            int prefix = firstByte & prefixMask;
            if (prefix < prefixMask) {
                return prefix;
            }
            int result = prefixMask;
            int shift = 0;
            while (((b = this.readByte()) & 0x80) != 0) {
                result += (b & 0x7F) << shift;
                shift += 7;
            }
            return result += b << shift;
        }

        ByteString readByteString(boolean asciiLowercase) throws IOException {
            int firstByte = this.readByte();
            boolean huffmanDecode = (firstByte & 0x80) == 128;
            int length = this.readInt(firstByte, 127);
            ByteString byteString = this.source.readByteString(length);
            if (huffmanDecode) {
                byteString = this.huffmanCodec.decode(byteString);
            }
            if (asciiLowercase) {
                byteString = byteString.toAsciiLowercase();
            }
            return byteString;
        }
    }
}

