/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface BitArray {
    public void clear();

    public void set(int var1);

    public void toggle(int var1);

    public boolean get(int var1);

    public void shiftLeft(int var1);

    public static final class VariableCapacity
    implements BitArray {
        long[] data;
        private int start;

        public VariableCapacity() {
            this.data = new long[1];
        }

        private VariableCapacity(FixedCapacity small) {
            this.data = new long[]{small.data, 0L};
        }

        private void growToSize(int size) {
            long[] newData = new long[size];
            if (this.data != null) {
                System.arraycopy(this.data, 0, newData, 0, this.data.length);
            }
            this.data = newData;
        }

        private int offsetOf(int index) {
            int offset = (index += this.start) / 64;
            if (offset > this.data.length - 1) {
                this.growToSize(offset + 1);
            }
            return offset;
        }

        private int shiftOf(int index) {
            return (index + this.start) % 64;
        }

        @Override
        public void clear() {
            Arrays.fill(this.data, 0L);
        }

        @Override
        public void set(int index) {
            int offset;
            VariableCapacity.checkInput(index);
            int n = offset = this.offsetOf(index);
            this.data[n] = this.data[n] | 1L << this.shiftOf(index);
        }

        @Override
        public void toggle(int index) {
            int offset;
            VariableCapacity.checkInput(index);
            int n = offset = this.offsetOf(index);
            this.data[n] = this.data[n] ^ 1L << this.shiftOf(index);
        }

        @Override
        public boolean get(int index) {
            VariableCapacity.checkInput(index);
            int offset = this.offsetOf(index);
            return (this.data[offset] & 1L << this.shiftOf(index)) != 0L;
        }

        @Override
        public void shiftLeft(int count) {
            this.start -= VariableCapacity.checkInput(count);
            if (this.start < 0) {
                int arrayShift = this.start / -64 + 1;
                long[] newData = new long[this.data.length + arrayShift];
                System.arraycopy(this.data, 0, newData, arrayShift, this.data.length);
                this.data = newData;
                this.start = 64 + this.start % 64;
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("{");
            List<Integer> ints = this.toIntegerList();
            int count = ints.size();
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    builder.append(',');
                }
                builder.append(ints.get(i));
            }
            return builder.append('}').toString();
        }

        List<Integer> toIntegerList() {
            ArrayList<Integer> ints = new ArrayList<Integer>();
            int count = this.data.length * 64 - this.start;
            for (int i = 0; i < count; ++i) {
                if (!this.get(i)) continue;
                ints.add(i);
            }
            return ints;
        }

        private static int checkInput(int index) {
            if (index < 0) {
                throw new IllegalArgumentException(String.format("input must be a positive number: %s", index));
            }
            return index;
        }
    }

    public static final class FixedCapacity
    implements BitArray {
        long data = 0L;

        @Override
        public void clear() {
            this.data = 0L;
        }

        @Override
        public void set(int index) {
            this.data |= 1L << FixedCapacity.checkInput(index);
        }

        @Override
        public void toggle(int index) {
            this.data ^= 1L << FixedCapacity.checkInput(index);
        }

        @Override
        public boolean get(int index) {
            return (this.data >> FixedCapacity.checkInput(index) & 1L) == 1L;
        }

        @Override
        public void shiftLeft(int count) {
            this.data <<= FixedCapacity.checkInput(count);
        }

        public String toString() {
            return Long.toBinaryString(this.data);
        }

        public BitArray toVariableCapacity() {
            return new VariableCapacity(this);
        }

        private static int checkInput(int index) {
            if (index < 0 || index > 63) {
                throw new IllegalArgumentException(String.format("input must be between 0 and 63: %s", index));
            }
            return index;
        }
    }
}

