/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp;

import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.Handshake;
import com.squareup.okhttp.Protocol;
import com.squareup.okhttp.Route;
import com.squareup.okhttp.TunnelRequest;
import com.squareup.okhttp.internal.Platform;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.HttpAuthenticator;
import com.squareup.okhttp.internal.http.HttpConnection;
import com.squareup.okhttp.internal.http.HttpEngine;
import com.squareup.okhttp.internal.http.HttpTransport;
import com.squareup.okhttp.internal.http.Request;
import com.squareup.okhttp.internal.http.Response;
import com.squareup.okhttp.internal.http.SpdyTransport;
import com.squareup.okhttp.internal.okio.BufferedSink;
import com.squareup.okhttp.internal.okio.BufferedSource;
import com.squareup.okhttp.internal.okio.ByteString;
import com.squareup.okhttp.internal.okio.Okio;
import com.squareup.okhttp.internal.spdy.SpdyConnection;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLSocket;

public final class Connection
implements Closeable {
    private final ConnectionPool pool;
    private final Route route;
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private BufferedSource source;
    private BufferedSink sink;
    private boolean connected = false;
    private HttpConnection httpConnection;
    private SpdyConnection spdyConnection;
    private int httpMinorVersion = 1;
    private long idleStartTimeNs;
    private Handshake handshake;
    private int recycleCount;
    private Object owner;

    public Connection(ConnectionPool pool, Route route) {
        this.pool = pool;
        this.route = route;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getOwner() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            return this.owner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(Object owner) {
        if (this.isSpdy()) {
            return;
        }
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.owner != null) {
                throw new IllegalStateException("Connection already has an owner!");
            }
            this.owner = owner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clearOwner() {
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.owner == null) {
                return false;
            }
            this.owner = null;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeIfOwnedBy(Object owner) throws IOException {
        if (this.isSpdy()) {
            throw new IllegalStateException();
        }
        ConnectionPool connectionPool = this.pool;
        synchronized (connectionPool) {
            if (this.owner != owner) {
                return;
            }
            this.owner = null;
        }
        this.socket.close();
    }

    public void connect(int connectTimeout, int readTimeout, TunnelRequest tunnelRequest) throws IOException {
        if (this.connected) {
            throw new IllegalStateException("already connected");
        }
        this.socket = this.route.proxy.type() != Proxy.Type.HTTP ? new Socket(this.route.proxy) : new Socket();
        Platform.get().connectSocket(this.socket, this.route.inetSocketAddress, connectTimeout);
        this.socket.setSoTimeout(readTimeout);
        this.in = this.socket.getInputStream();
        this.out = this.socket.getOutputStream();
        if (this.route.address.sslSocketFactory != null) {
            this.upgradeToTls(tunnelRequest);
        } else {
            this.initSourceAndSink();
            this.httpConnection = new HttpConnection(this.pool, this, this.source, this.sink);
        }
        this.connected = true;
    }

    private void upgradeToTls(TunnelRequest tunnelRequest) throws IOException {
        ByteString maybeProtocol;
        boolean useNpn;
        Platform platform = Platform.get();
        if (this.requiresTunnel()) {
            this.makeTunnel(tunnelRequest);
        }
        this.socket = this.route.address.sslSocketFactory.createSocket(this.socket, this.route.address.uriHost, this.route.address.uriPort, true);
        SSLSocket sslSocket = (SSLSocket)this.socket;
        if (this.route.modernTls) {
            platform.enableTlsExtensions(sslSocket, this.route.address.uriHost);
        } else {
            platform.supportTlsIntolerantServer(sslSocket);
        }
        boolean bl = useNpn = this.route.modernTls && (this.route.address.protocols.contains((Object)Protocol.HTTP_2) || this.route.address.protocols.contains((Object)Protocol.SPDY_3));
        if (useNpn) {
            if (this.route.address.protocols.contains((Object)Protocol.HTTP_2) && this.route.address.protocols.contains((Object)Protocol.SPDY_3)) {
                platform.setNpnProtocols(sslSocket, Util.HTTP2_SPDY3_AND_HTTP);
            } else if (this.route.address.protocols.contains((Object)Protocol.HTTP_2)) {
                platform.setNpnProtocols(sslSocket, Util.HTTP2_AND_HTTP_11);
            } else {
                platform.setNpnProtocols(sslSocket, Util.SPDY3_AND_HTTP11);
            }
        }
        sslSocket.startHandshake();
        if (!this.route.address.hostnameVerifier.verify(this.route.address.uriHost, sslSocket.getSession())) {
            throw new IOException("Hostname '" + this.route.address.uriHost + "' was not verified");
        }
        this.out = sslSocket.getOutputStream();
        this.in = sslSocket.getInputStream();
        this.handshake = Handshake.get(sslSocket.getSession());
        this.initSourceAndSink();
        Protocol selectedProtocol = Protocol.HTTP_11;
        if (useNpn && (maybeProtocol = platform.getNpnSelectedProtocol(sslSocket)) != null) {
            selectedProtocol = Util.getProtocol(maybeProtocol);
        }
        if (selectedProtocol.spdyVariant) {
            sslSocket.setSoTimeout(0);
            this.spdyConnection = new SpdyConnection.Builder(this.route.address.getUriHost(), true, this.source, this.sink).protocol(selectedProtocol).build();
            this.spdyConnection.sendConnectionHeader();
        } else {
            this.httpConnection = new HttpConnection(this.pool, this, this.source, this.sink);
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    public Route getRoute() {
        return this.route;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public boolean isAlive() {
        return !this.socket.isClosed() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isReadable() {
        if (this.source == null) {
            return true;
        }
        if (this.isSpdy()) {
            return true;
        }
        try {
            int readTimeout = this.socket.getSoTimeout();
            try {
                this.socket.setSoTimeout(1);
                if (this.source.exhausted()) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.socket.setSoTimeout(readTimeout);
            }
        }
        catch (SocketTimeoutException ignored) {
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void resetIdleStartTime() {
        if (this.spdyConnection != null) {
            throw new IllegalStateException("spdyConnection != null");
        }
        this.idleStartTimeNs = System.nanoTime();
    }

    public boolean isIdle() {
        return this.spdyConnection == null || this.spdyConnection.isIdle();
    }

    public boolean isExpired(long keepAliveDurationNs) {
        return this.getIdleStartTimeNs() < System.nanoTime() - keepAliveDurationNs;
    }

    public long getIdleStartTimeNs() {
        return this.spdyConnection == null ? this.idleStartTimeNs : this.spdyConnection.getIdleStartTimeNs();
    }

    public Handshake getHandshake() {
        return this.handshake;
    }

    public Object newTransport(HttpEngine httpEngine) throws IOException {
        return this.spdyConnection != null ? new SpdyTransport(httpEngine, this.spdyConnection) : new HttpTransport(httpEngine, this.httpConnection);
    }

    public boolean isSpdy() {
        return this.spdyConnection != null;
    }

    public int getHttpMinorVersion() {
        return this.httpMinorVersion;
    }

    public void setHttpMinorVersion(int httpMinorVersion) {
        this.httpMinorVersion = httpMinorVersion;
    }

    public boolean requiresTunnel() {
        return this.route.address.sslSocketFactory != null && this.route.proxy.type() == Proxy.Type.HTTP;
    }

    public void updateReadTimeout(int newTimeout) throws IOException {
        if (!this.connected) {
            throw new IllegalStateException("updateReadTimeout - not connected");
        }
        this.socket.setSoTimeout(newTimeout);
    }

    public void incrementRecycleCount() {
        ++this.recycleCount;
    }

    public int recycleCount() {
        return this.recycleCount;
    }

    private void makeTunnel(TunnelRequest tunnelRequest) throws IOException {
        Response response;
        BufferedSource tunnelSource = Okio.buffer(Okio.source(this.in));
        BufferedSink tunnelSink = Okio.buffer(Okio.sink(this.out));
        HttpConnection tunnelConnection = new HttpConnection(this.pool, this, tunnelSource, tunnelSink);
        Request request = tunnelRequest.getRequest();
        String requestLine = tunnelRequest.requestLine();
        block4: while (true) {
            tunnelConnection.writeRequest(request.headers(), requestLine);
            tunnelConnection.flush();
            response = tunnelConnection.readResponse().request(request).build();
            tunnelConnection.emptyResponseBody();
            switch (response.code()) {
                case 200: {
                    if (tunnelSource.buffer().size() > 0L) {
                        throw new IOException("TLS tunnel buffered too many bytes!");
                    }
                    return;
                }
                case 407: {
                    request = HttpAuthenticator.processAuthHeader(this.route.address.authenticator, response, this.route.proxy);
                    if (request != null) continue block4;
                    throw new IOException("Failed to authenticate with proxy");
                }
            }
            break;
        }
        throw new IOException("Unexpected response code for CONNECT: " + response.code());
    }

    private void initSourceAndSink() throws IOException {
        this.source = Okio.buffer(Okio.source(this.in));
        this.sink = Okio.buffer(Okio.sink(this.out));
    }
}

