/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.chain.rcp;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import java.lang.reflect.Field;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.codeassist.InternalExtendedCompletionContext;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.recommenders.completion.rcp.CompletionContextKey;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;

@Beta
public final class ScopeAccessWorkaround {
    private static Field extendedContextField;
    private static Field assistScopeField;

    static {
        try {
            extendedContextField = InternalCompletionContext.class.getDeclaredField("extendedContext");
            extendedContextField.setAccessible(true);
            assistScopeField = InternalExtendedCompletionContext.class.getDeclaredField("assistScope");
            assistScopeField.setAccessible(true);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private ScopeAccessWorkaround() {
    }

    static Optional<Scope> resolveScope(IRecommendersCompletionContext ctx) {
        InternalCompletionContext context = (InternalCompletionContext)ctx.get(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, null);
        if (context == null) {
            return Optional.absent();
        }
        try {
            InternalExtendedCompletionContext extendedContext = (InternalExtendedCompletionContext)extendedContextField.get(context);
            if (extendedContext == null) {
                return Optional.absent();
            }
            return Optional.fromNullable((Object)((Scope)assistScopeField.get(extendedContext)));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

