/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;

public class URLUtil {
    public static URI toURI(String s) throws URISyntaxException {
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            URL url;
            try {
                url = new URL(s);
            }
            catch (MalformedURLException malformedURLException) {
                throw e;
            }
            if (!s.equals(url.toString())) {
                try {
                    return url.toURI();
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            try {
                return new URI(url.getProtocol(), url.getAuthority(), URLUtil.decode(url.getPath()), URLUtil.encodeQuery(url.getQuery()), url.getRef());
            }
            catch (URISyntaxException uRISyntaxException) {
                throw e;
            }
        }
    }

    private static String decode(String path) {
        try {
            return path == null ? null : URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return path;
        }
    }

    public static URL toURL(String s) throws MalformedURLException {
        try {
            URI uri = URLUtil.toURI(s);
            return uri.toURL();
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    public static String encode(String url) throws URISyntaxException {
        return URLUtil.toURI(url).toString();
    }

    private static String encodeQuery(String query) {
        return query == null ? null : query.replace(" ", "+");
    }
}

