/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core;

import org.eclipse.epp.mpc.core.service.IMarketplaceServiceLocator;
import org.eclipse.epp.mpc.core.service.IMarketplaceUnmarshaller;
import org.eclipse.epp.mpc.core.service.ITransportFactory;
import org.eclipse.epp.mpc.core.service.ServiceHelper;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

class ServiceHelperImpl
extends ServiceHelper {
    private ServiceTracker<IMarketplaceServiceLocator, IMarketplaceServiceLocator> locatorServiceTracker;
    private ServiceTracker<ITransportFactory, ITransportFactory> transportFactoryTracker;
    private ServiceTracker<IMarketplaceUnmarshaller, IMarketplaceUnmarshaller> unmarshallerTracker;

    ServiceHelperImpl() {
    }

    void startTracking(BundleContext context) {
        this.locatorServiceTracker = new ServiceTracker(context, IMarketplaceServiceLocator.class, null);
        this.locatorServiceTracker.open(true);
        this.transportFactoryTracker = new ServiceTracker(context, ITransportFactory.class, null);
        this.transportFactoryTracker.open(true);
        this.unmarshallerTracker = new ServiceTracker(context, IMarketplaceUnmarshaller.class, null);
        this.unmarshallerTracker.open(true);
    }

    void stopTracking(BundleContext context) {
        if (this.locatorServiceTracker != null) {
            this.locatorServiceTracker.close();
            this.locatorServiceTracker = null;
        }
        if (this.transportFactoryTracker != null) {
            this.transportFactoryTracker.close();
            this.transportFactoryTracker = null;
        }
        if (this.unmarshallerTracker != null) {
            this.unmarshallerTracker.close();
            this.unmarshallerTracker = null;
        }
    }

    protected IMarketplaceServiceLocator doGetMarketplaceServiceLocator() {
        return this.locatorServiceTracker == null ? null : (IMarketplaceServiceLocator)this.locatorServiceTracker.getService();
    }

    protected IMarketplaceUnmarshaller doGetMarketplaceUnmarshaller() {
        return this.unmarshallerTracker == null ? null : (IMarketplaceUnmarshaller)this.unmarshallerTracker.getService();
    }

    protected ITransportFactory doGetTransportFactory() {
        return this.transportFactoryTracker == null ? null : (ITransportFactory)this.transportFactoryTracker.getService();
    }
}

