/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.core.model.JDIInterfaceType;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIVariable;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.OpenVariableDeclaredTypeAction;
import org.eclipse.jdt.internal.debug.ui.actions.OpenVariableTypeAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class OpenVariableConcreteTypeAction
extends OpenVariableTypeAction {
    protected IJavaType getTypeToOpen(IDebugElement element) throws CoreException {
        if (element instanceof IJavaVariable) {
            IJavaVariable variable = (IJavaVariable)element;
            return ((IJavaValue)variable.getValue()).getJavaType();
        }
        return null;
    }

    public void run(IAction action) {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null) {
            return;
        }
        Iterator itr = selection.iterator();
        try {
            while (itr.hasNext()) {
                JDIObjectValue val;
                Object element = itr.next();
                if (element instanceof JDIVariable && ((JDIVariable)element).getJavaType() instanceof JDIInterfaceType && (val = (JDIObjectValue)((JDIVariable)element).getValue()).getJavaType().toString().contains("$$Lambda$")) {
                    OpenVariableDeclaredTypeAction declaredAction = new OpenVariableDeclaredTypeAction();
                    declaredAction.setActivePart(action, this.getPart());
                    declaredAction.run(action);
                    return;
                }
                Object sourceElement = this.resolveSourceElement(element);
                if (sourceElement != null) {
                    this.openInEditor(sourceElement);
                    continue;
                }
                Status status = new Status(1, IJavaDebugUIConstants.PLUGIN_ID, 150, "Source not found", null);
                throw new CoreException((IStatus)status);
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.statusDialog(e.getStatus());
        }
    }
}

