/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.binding.editors;

import org.eclipse.wb.internal.core.utils.binding.IDataEditor;
import org.eclipse.wb.internal.core.utils.binding.ValueUtils;
import org.eclipse.wb.internal.core.utils.dialogfields.SelectionButtonDialogFieldGroup;

public class SelectionButtonGroupEditor
implements IDataEditor {
    private final SelectionButtonDialogFieldGroup m_field;
    private final int m_buttonCount;

    public SelectionButtonGroupEditor(SelectionButtonDialogFieldGroup field, int buttonCount) {
        this.m_field = field;
        this.m_buttonCount = buttonCount;
    }

    public Object getValue() {
        boolean[] values = new boolean[this.m_buttonCount];
        int i = 0;
        while (i < this.m_buttonCount) {
            values[i] = this.m_field.isSelected(i);
            ++i;
        }
        return values;
    }

    public void setValue(Object value) {
        boolean[] values = ValueUtils.objectToBooleanArray(value);
        if (values != null && values.length == this.m_buttonCount) {
            int i = 0;
            while (i < this.m_buttonCount) {
                this.m_field.setSelection(i, values[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.m_buttonCount) {
                this.m_field.setSelection(i, false);
                ++i;
            }
        }
    }
}

