/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.draw2d.border;

import org.eclipse.swt.graphics.Color;
import org.eclipse.wb.draw2d.Graphics;
import org.eclipse.wb.draw2d.border.Border;
import org.eclipse.wb.draw2d.geometry.Insets;
import org.eclipse.wb.draw2d.geometry.Rectangle;

public class LineBorder
extends Border {
    private final Color m_color;
    private final int m_width;

    public LineBorder(Color color, int width) {
        super(new Insets(width));
        this.m_color = color;
        this.m_width = width;
    }

    public LineBorder() {
        this(null, 1);
    }

    public LineBorder(int width) {
        this(null, width);
    }

    public LineBorder(Color color) {
        this(color, 1);
    }

    public Color getColor() {
        return this.m_color;
    }

    public int getWidth() {
        return this.m_width;
    }

    public void paint(int ownerWidth, int ownerHeight, Graphics graphics) {
        Rectangle paintBorderRectangle = new Rectangle(0, 0, ownerWidth, ownerHeight);
        if (this.m_width % 2 != 0) {
            --paintBorderRectangle.width;
            --paintBorderRectangle.height;
        }
        paintBorderRectangle.shrink(this.m_width / 2, this.m_width / 2);
        graphics.setLineWidth(this.m_width);
        if (this.m_color != null) {
            graphics.setForegroundColor(this.m_color);
        }
        graphics.drawRectangle(paintBorderRectangle);
    }
}

