/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.AddRepositoryAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.internal.tasks.ui.wizards.SelectRepositoryConnectorPage;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewRepositoryWizard
extends Wizard
implements INewWizard {
    private static final String PREF_ADD_QUERY = "org.eclipse.mylyn.internal.tasks.add.query";
    private AbstractRepositoryConnector connector;
    private final String connectorKind;
    private TaskRepository taskRepository;
    private SelectRepositoryConnectorPage selectConnectorPage;
    private ITaskRepositoryPage settingsPage;
    private String lastConnectorKind;
    private boolean showNewQueryPromptOnFinish;

    public NewRepositoryWizard() {
        this(null);
    }

    public NewRepositoryWizard(String connectorKind) {
        this.connectorKind = connectorKind;
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
        this.setForcePreviousAndNextButtons(connectorKind == null);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(AddRepositoryAction.TITLE);
        this.setShowNewQueryPromptOnFinish(true);
    }

    public void addPages() {
        if (this.connectorKind != null && TasksUi.getRepositoryManager().getRepositoryConnector(this.connectorKind).canCreateRepository()) {
            this.connector = TasksUi.getRepositoryManager().getRepositoryConnector(this.connectorKind);
            this.updateSettingsPage();
            if (this.settingsPage != null) {
                this.addPage(this.settingsPage);
            }
        } else {
            this.selectConnectorPage = new SelectRepositoryConnectorPage();
            this.addPage((IWizardPage)this.selectConnectorPage);
        }
    }

    public boolean canFinish() {
        return (this.selectConnectorPage == null || this.selectConnectorPage.isPageComplete()) && this.getContainer().getCurrentPage() != this.selectConnectorPage && this.settingsPage != null && this.settingsPage.isPageComplete();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.selectConnectorPage) {
            this.connector = this.selectConnectorPage.getConnector();
            this.updateSettingsPage();
            return this.settingsPage;
        }
        return super.getNextPage(page);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            this.taskRepository = new TaskRepository(this.connector.getConnectorKind(), this.settingsPage.getRepositoryUrl());
            boolean finishAccepted = this.settingsPage.preFinish(this.taskRepository);
            if (finishAccepted) {
                this.settingsPage.performFinish(this.taskRepository);
                TasksUi.getRepositoryManager().addRepository(this.taskRepository);
                if (this.showNewQueryPromptOnFinish() && this.connector.canQuery(this.taskRepository)) {
                    this.promptToAddQuery(this.taskRepository);
                }
                return true;
            }
        }
        return false;
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    private void updateSettingsPage() {
        assert (this.connector != null);
        if (!this.connector.getConnectorKind().equals(this.lastConnectorKind)) {
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(this.connector.getConnectorKind());
            this.settingsPage = connectorUi.getSettingsPage(null);
            if (this.settingsPage == null) {
                TasksUiInternal.displayFrameworkError(NLS.bind((String)"The connector implementation is incomplete: AbstractRepositoryConnectorUi.getSettingsPage() for connector ''{0}'' returned null. Please contact the vendor of the connector to resolve the problem.", (Object)this.connector.getConnectorKind()));
            }
            this.settingsPage.setWizard((IWizard)this);
            this.lastConnectorKind = this.connector.getConnectorKind();
        }
    }

    public void promptToAddQuery(TaskRepository taskRepository) {
        IPreferenceStore preferenceStore = TasksUiPlugin.getDefault().getPreferenceStore();
        if (!preferenceStore.getBoolean(PREF_ADD_QUERY)) {
            MessageDialogWithToggle messageDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getShell(), (String)Messages.AddRepositoryAction_Add_new_query, (String)Messages.AddRepositoryAction_Add_a_query_to_the_Task_List, (String)Messages.AddRepositoryAction_Do_not_show_again, (boolean)false, (IPreferenceStore)preferenceStore, (String)PREF_ADD_QUERY);
            preferenceStore.setValue(PREF_ADD_QUERY, messageDialog.getToggleState());
            if (messageDialog.getReturnCode() == 2) {
                AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(taskRepository.getConnectorKind());
                final IWizard queryWizard = connectorUi.getQueryWizard(taskRepository, null);
                if (queryWizard instanceof Wizard) {
                    ((Wizard)queryWizard).setForcePreviousAndNextButtons(true);
                }
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        WizardDialog queryDialog = new WizardDialog(WorkbenchUtil.getShell(), queryWizard);
                        queryDialog.create();
                        queryDialog.setBlockOnOpen(true);
                        queryDialog.open();
                    }
                });
            }
        }
    }

    public boolean showNewQueryPromptOnFinish() {
        return this.showNewQueryPromptOnFinish;
    }

    public void setShowNewQueryPromptOnFinish(boolean showNewQueryPromptOnFinish) {
        this.showNewQueryPromptOnFinish = showNewQueryPromptOnFinish;
    }
}

