/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.tips;

import java.util.Dictionary;
import javax.inject.Inject;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.DiscoveryCore;
import org.eclipse.equinox.internal.p2.discovery.compatibility.RemoteBundleDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogConfiguration;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.DiscoveryWizard;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.recommenders.completion.rcp.tips.AbstractCompletionTipProposal;
import org.eclipse.recommenders.internal.completion.rcp.Messages;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class DiscoveryCompletionProposal
extends AbstractCompletionTipProposal {
    private static final String DISCOVERY_URL = "http://download.eclipse.org/recommenders/discovery/2.0/directory.xml";

    @Inject
    public DiscoveryCompletionProposal(SharedImages images) {
        Image image = images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_LIGHTBULB);
        this.setImage(image);
        StyledString text = new StyledString(Messages.PROPOSAL_LABEL_DISCOVER_EXTENSIONS, StyledString.DECORATIONS_STYLER);
        this.setStyledDisplayString(text);
        this.setSortString(text.getString());
    }

    @Override
    public boolean isApplicable() {
        return true;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        Catalog catalog = new Catalog();
        Dictionary env = DiscoveryCore.createEnvironment();
        catalog.setEnvironment(env);
        catalog.setVerifyUpdateSiteAvailability(false);
        RemoteBundleDiscoveryStrategy remoteDiscoveryStrategy = new RemoteBundleDiscoveryStrategy();
        remoteDiscoveryStrategy.setDirectoryUrl(DISCOVERY_URL);
        catalog.getDiscoveryStrategies().add(remoteDiscoveryStrategy);
        CatalogConfiguration configuration = new CatalogConfiguration();
        configuration.setShowTagFilter(false);
        DiscoveryWizard wizard = new DiscoveryWizard(catalog, configuration);
        WizardDialog dialog = new WizardDialog(WorkbenchUtil.getShell(), (IWizard)wizard);
        dialog.open();
    }

    @Override
    protected IInformationControl createInformationControl(Shell parent, String statusLineText) {
        return new ConfigureContentAssistInformationControl(parent, statusLineText);
    }

    private final class ConfigureContentAssistInformationControl
    extends AbstractInformationControl {
        private ConfigureContentAssistInformationControl(Shell parent, String statusLineText) {
            super(parent, statusLineText);
            this.create();
        }

        public boolean hasContents() {
            return true;
        }

        protected void createContent(Composite parent) {
            Display display = parent.getDisplay();
            Color bg = display.getSystemColor(29);
            Link link = new Link(parent, 0);
            link.setBackground(bg);
            link.setText(Messages.PROPOSAL_TOOLTIP_DISCOVER_EXTENSIONS);
        }
    }
}

