/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.io.xmlbif;

import com.google.common.primitives.Doubles;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.eclipse.recommenders.internal.jayes.io.util.XPathUtil;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.io.IBayesNetReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.xpath.XPathEvaluator;
import org.xml.sax.SAXException;

public class XMLBIFReader
implements IBayesNetReader {
    private final InputStream in;

    public XMLBIFReader(InputStream in) {
        this.in = in;
    }

    @Override
    public BayesNet read() throws IOException {
        Document doc;
        try {
            doc = this.obtainDocument(this.in);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        return this.readFromDocument(doc);
    }

    private Document obtainDocument(InputStream biffile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(true);
        DocumentBuilder docBldr = docBuilderFactory.newDocumentBuilder();
        Document doc = docBldr.parse(biffile);
        doc.normalize();
        return doc;
    }

    public BayesNet readFromString(String xmlBif) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(true);
        DocumentBuilder docBldr = docBuilderFactory.newDocumentBuilder();
        Document doc = docBldr.parse(new ByteArrayInputStream(xmlBif.getBytes()));
        return this.readFromDocument(doc);
    }

    private BayesNet readFromDocument(Document doc) {
        BayesNet net = new BayesNet();
        net.setName(doc.getElementsByTagName("NAME").item(0).getTextContent());
        this.initializeNodes(doc, net);
        XPathEvaluator xpath = this.getXPathEvaluator(doc);
        NodeList nodelist = doc.getElementsByTagName("DEFINITION");
        int i = 0;
        while (i < nodelist.getLength()) {
            Node node = nodelist.item(i);
            String name = XPathUtil.evalXPath(xpath, "FOR", node).next().getTextContent();
            BayesNode bNode = net.getNode(name);
            this.setParents(bNode, net, node, xpath);
            this.parseProbabilities(xpath, node, bNode);
            ++i;
        }
        return net;
    }

    private void initializeNodes(Document doc, BayesNet net) {
        XPathEvaluator xpath = this.getXPathEvaluator(doc);
        NodeList nodelist = doc.getElementsByTagName("VARIABLE");
        int i = 0;
        while (i < nodelist.getLength()) {
            Node node = nodelist.item(i);
            Node name = XPathUtil.evalXPath(xpath, "NAME", node).next();
            BayesNode bNode = net.createNode(name.getTextContent());
            Iterator<Node> it = XPathUtil.evalXPath(xpath, "OUTCOME", node);
            while (it.hasNext()) {
                bNode.addOutcome(StringEscapeUtils.unescapeXml((String)it.next().getTextContent()));
            }
            ++i;
        }
    }

    private XPathEvaluator getXPathEvaluator(Document doc) {
        return (XPathEvaluator)doc.getFeature("+XPath", null);
    }

    private void setParents(BayesNode bNode, BayesNet net, Node node, XPathEvaluator xpath) {
        ArrayList<BayesNode> parents = new ArrayList<BayesNode>();
        Iterator<Node> it = XPathUtil.evalXPath(xpath, "GIVEN", node);
        while (it.hasNext()) {
            parents.add(net.getNode(it.next().getTextContent()));
        }
        bNode.setParents(parents);
    }

    private void parseProbabilities(XPathEvaluator xpath, Node node, BayesNode bNode) {
        String table = XPathUtil.evalXPath(xpath, "TABLE", node).next().getTextContent();
        ArrayList<Double> probabilities = new ArrayList<Double>();
        StringTokenizer tok = new StringTokenizer(table);
        while (tok.hasMoreTokens()) {
            probabilities.add(Double.valueOf(tok.nextToken()));
        }
        bNode.setProbabilities(Doubles.toArray(probabilities));
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

