/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.operations;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.epp.internal.mpc.core.util.URLUtil;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.operation.IRunnableWithProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProvisioningOperation
implements IRunnableWithProgress {
    protected static final String P2_FEATURE_GROUP_SUFFIX = ".feature.group";
    protected final List<CatalogItem> items;
    protected final ProvisioningUI provisioningUI;
    protected Set<URI> repositoryLocations;
    protected Set<URI> addedRepositoryLocations;

    protected AbstractProvisioningOperation(Collection<CatalogItem> installableConnectors) {
        if (installableConnectors == null || installableConnectors.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.items = new ArrayList<CatalogItem>(installableConnectors);
        this.provisioningUI = ProvisioningUI.getDefaultUI();
    }

    protected List<IMetadataRepository> addRepositories(SubMonitor monitor) throws URISyntaxException, ProvisionException {
        ProvisioningSession session = ProvisioningUI.getDefaultUI().getSession();
        RepositoryTracker repositoryTracker = ProvisioningUI.getDefaultUI().getRepositoryTracker();
        this.repositoryLocations = new HashSet<URI>();
        if (this.addedRepositoryLocations == null) {
            this.addedRepositoryLocations = new HashSet<URI>();
        }
        HashSet<URI> knownRepositories = new HashSet<URI>(Arrays.asList(repositoryTracker.getKnownRepositories(session)));
        monitor.setWorkRemaining(this.items.size() * 5);
        for (CatalogItem descriptor : this.items) {
            URI uri = URLUtil.toURI((String)descriptor.getSiteUrl());
            if (this.repositoryLocations.add(uri) && !knownRepositories.contains(uri)) {
                this.checkCancelled((IProgressMonitor)monitor);
                repositoryTracker.addRepository(uri, null, session);
                this.addedRepositoryLocations.add(uri);
            }
            monitor.worked(1);
        }
        ArrayList<IMetadataRepository> repositories = new ArrayList<IMetadataRepository>();
        monitor.setWorkRemaining(repositories.size());
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)session.getProvisioningAgent().getService(IMetadataRepositoryManager.SERVICE_NAME);
        for (URI uri : this.repositoryLocations) {
            this.checkCancelled((IProgressMonitor)monitor);
            IMetadataRepository repository = manager.loadRepository(uri, (IProgressMonitor)monitor.newChild(1));
            repositories.add(repository);
        }
        return repositories;
    }

    protected List<IInstallableUnit> queryInstallableUnits(SubMonitor monitor, List<IMetadataRepository> repositories) throws URISyntaxException {
        ArrayList<IInstallableUnit> installableUnits = new ArrayList<IInstallableUnit>();
        monitor.setWorkRemaining(repositories.size());
        for (IMetadataRepository repository : repositories) {
            this.checkCancelled((IProgressMonitor)monitor);
            Set<String> installableUnitIdsThisRepository = this.getDescriptorIds(repository);
            IQuery query = QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUGroupQuery());
            IQueryResult result = repository.query(query, (IProgressMonitor)monitor.newChild(1));
            for (IInstallableUnit iu : result) {
                String id = iu.getId();
                if (!installableUnitIdsThisRepository.contains(id)) continue;
                installableUnits.add(iu);
            }
        }
        return installableUnits;
    }

    private Set<String> getDescriptorIds(IMetadataRepository repository) throws URISyntaxException {
        HashSet<String> installableUnitIdsThisRepository = new HashSet<String>();
        for (CatalogItem descriptor : this.items) {
            if (!repository.getLocation().equals(URLUtil.toURI((String)descriptor.getSiteUrl()))) continue;
            installableUnitIdsThisRepository.addAll(this.getFeatureIds(descriptor));
        }
        return installableUnitIdsThisRepository;
    }

    protected Set<String> getFeatureIds(CatalogItem descriptor) {
        HashSet<String> featureIds = new HashSet<String>();
        for (String id : descriptor.getInstallableUnits()) {
            if (!id.endsWith(P2_FEATURE_GROUP_SUFFIX)) {
                id = String.valueOf(id) + P2_FEATURE_GROUP_SUFFIX;
            }
            featureIds.add(id);
        }
        return featureIds;
    }

    protected void checkCancelled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public Set<URI> getAddedRepositoryLocations() {
        return this.addedRepositoryLocations;
    }

    protected void removeAddedRepositoryLocations() {
        if (this.addedRepositoryLocations != null) {
            AbstractProvisioningOperation.removeRepositoryLocations(this.addedRepositoryLocations);
            this.addedRepositoryLocations = null;
        }
    }

    public static void removeRepositoryLocations(Set<URI> repositoryLocations) {
        if (repositoryLocations == null || repositoryLocations.isEmpty()) {
            return;
        }
        ProvisioningSession session = ProvisioningUI.getDefaultUI().getSession();
        RepositoryTracker repositoryTracker = ProvisioningUI.getDefaultUI().getRepositoryTracker();
        repositoryTracker.removeRepositories(repositoryLocations.toArray(new URI[repositoryLocations.size()]), session);
    }
}

