/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.commands.IStateListener;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefNode;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefsNode;
import org.eclipse.egit.ui.internal.repository.tree.BranchHierarchyNode;
import org.eclipse.egit.ui.internal.repository.tree.BranchesNode;
import org.eclipse.egit.ui.internal.repository.tree.ErrorNode;
import org.eclipse.egit.ui.internal.repository.tree.FetchNode;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.LocalNode;
import org.eclipse.egit.ui.internal.repository.tree.PushNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RemoteNode;
import org.eclipse.egit.ui.internal.repository.tree.RemoteTrackingNode;
import org.eclipse.egit.ui.internal.repository.tree.RemotesNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.StashNode;
import org.eclipse.egit.ui.internal.repository.tree.StashedCommitNode;
import org.eclipse.egit.ui.internal.repository.tree.SubmodulesNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.repository.tree.TagsNode;
import org.eclipse.egit.ui.internal.repository.tree.WorkingDirNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedEvent;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoriesViewContentProvider
implements ITreeContentProvider,
IStateListener {
    private final RepositoryCache repositoryCache = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache();
    private final State commandState;
    private boolean branchHierarchyMode = false;
    private Map<Repository, Map<String, Ref>> branchRefs = new WeakHashMap<Repository, Map<String, Ref>>();
    private Map<Repository, ListenerHandle> refsChangedListeners = new WeakHashMap<Repository, ListenerHandle>();

    public RepositoriesViewContentProvider() {
        ICommandService srv = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.commandState = srv.getCommand("org.eclipse.egit.ui.RepositoriesToggleBranchHierarchy").getState("org.eclipse.ui.commands.toggleState");
        this.commandState.addListener((IStateListener)this);
        try {
            this.branchHierarchyMode = (Boolean)this.commandState.getValue();
        }
        catch (Exception e) {
            Activator.handleError(e.getMessage(), e, false);
        }
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<RepositoryTreeNode> nodes = new ArrayList<RepositoryTreeNode>();
        ArrayList<String> directories = new ArrayList<String>();
        RepositoryUtil repositoryUtil = Activator.getDefault().getRepositoryUtil();
        if (inputElement instanceof Collection) {
            for (Object next : (Collection)inputElement) {
                if (next instanceof RepositoryTreeNode) {
                    nodes.add((RepositoryTreeNode)next);
                    continue;
                }
                if (!(next instanceof String)) continue;
                directories.add((String)next);
            }
        } else if (inputElement instanceof IWorkspaceRoot) {
            directories.addAll(repositoryUtil.getConfiguredRepositories());
        }
        for (String directory : directories) {
            try {
                File gitDir = new File(directory);
                if (gitDir.exists()) {
                    RepositoryNode rNode = new RepositoryNode(null, this.repositoryCache.lookupRepository(gitDir));
                    nodes.add(rNode);
                    continue;
                }
                repositoryUtil.removeDir(gitDir);
            }
            catch (IOException iOException) {}
        }
        Collections.sort(nodes);
        return nodes.toArray();
    }

    public void dispose() {
        this.commandState.removeListener((IStateListener)this);
        for (ListenerHandle handle : this.refsChangedListeners.values()) {
            handle.remove();
        }
        this.refsChangedListeners.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        RepositoryTreeNode node = (RepositoryTreeNode)parentElement;
        Repository repo = node.getRepository();
        switch (node.getType()) {
            case BRANCHES: {
                ArrayList<RepositoryTreeNode> nodes = new ArrayList<RepositoryTreeNode>();
                nodes.add(new LocalNode(node, repo));
                nodes.add(new RemoteTrackingNode(node, repo));
                return nodes.toArray();
            }
            case LOCAL: {
                if (this.branchHierarchyMode) {
                    BranchHierarchyNode hierNode = new BranchHierarchyNode(node, repo, (IPath)new Path("refs/heads/"));
                    ArrayList<RepositoryTreeNode> children = new ArrayList<RepositoryTreeNode>();
                    try {
                        for (IPath path : hierNode.getChildPaths()) {
                            children.add(new BranchHierarchyNode(node, node.getRepository(), path));
                        }
                        for (Ref ref : hierNode.getChildRefs()) {
                            children.add(new RefNode(node, node.getRepository(), ref));
                        }
                    }
                    catch (Exception e) {
                        return this.handleException(e, node);
                    }
                    return children.toArray();
                }
                ArrayList<RefNode> refs = new ArrayList<RefNode>();
                try {
                    for (Map.Entry<String, Ref> refEntry : this.getRefs(repo, "refs/heads/").entrySet()) {
                        if (refEntry.getValue().isSymbolic()) continue;
                        refs.add(new RefNode(node, repo, refEntry.getValue()));
                    }
                }
                catch (Exception e) {
                    return this.handleException(e, node);
                }
                return refs.toArray();
            }
            case REMOTETRACKING: {
                if (this.branchHierarchyMode) {
                    BranchHierarchyNode hierNode = new BranchHierarchyNode(node, repo, (IPath)new Path("refs/remotes/"));
                    ArrayList<RepositoryTreeNode> children = new ArrayList<RepositoryTreeNode>();
                    try {
                        for (IPath path : hierNode.getChildPaths()) {
                            children.add(new BranchHierarchyNode(node, node.getRepository(), path));
                        }
                        for (Ref ref : hierNode.getChildRefs()) {
                            children.add(new RefNode(node, node.getRepository(), ref));
                        }
                    }
                    catch (Exception e) {
                        return this.handleException(e, node);
                    }
                    return children.toArray();
                }
                ArrayList<RefNode> refs = new ArrayList<RefNode>();
                try {
                    for (Map.Entry<String, Ref> refEntry : this.getRefs(repo, "refs/remotes/").entrySet()) {
                        if (refEntry.getValue().isSymbolic()) continue;
                        refs.add(new RefNode(node, repo, refEntry.getValue()));
                    }
                }
                catch (Exception e) {
                    return this.handleException(e, node);
                }
                return refs.toArray();
            }
            case BRANCHHIERARCHY: {
                BranchHierarchyNode hierNode = (BranchHierarchyNode)node;
                ArrayList<RepositoryTreeNode> children = new ArrayList<RepositoryTreeNode>();
                try {
                    for (IPath path : hierNode.getChildPaths()) {
                        children.add(new BranchHierarchyNode(node, node.getRepository(), path));
                    }
                    for (Ref ref : hierNode.getChildRefs()) {
                        children.add(new RefNode(node, node.getRepository(), ref));
                    }
                }
                catch (IOException e) {
                    return this.handleException(e, node);
                }
                return children.toArray();
            }
            case TAGS: {
                return this.getTagsChildren(node, repo);
            }
            case ADDITIONALREFS: {
                ArrayList<AdditionalRefNode> refs = new ArrayList<AdditionalRefNode>();
                try {
                    for (Map.Entry<String, Ref> refEntry : this.getRefs(repo, "").entrySet()) {
                        String name = refEntry.getKey();
                        if (name.startsWith("refs/heads/") || name.startsWith("refs/tags/") || name.startsWith("refs/remotes/")) continue;
                        refs.add(new AdditionalRefNode(node, repo, refEntry.getValue()));
                    }
                    for (Ref r : repo.getRefDatabase().getAdditionalRefs()) {
                        refs.add(new AdditionalRefNode(node, repo, r));
                    }
                }
                catch (Exception e) {
                    return this.handleException(e, node);
                }
                return refs.toArray();
            }
            case REMOTES: {
                ArrayList<RemoteNode> remotes = new ArrayList<RemoteNode>();
                Repository rep = node.getRepository();
                Set configNames = rep.getConfig().getSubsections("remote");
                for (String configName : configNames) {
                    remotes.add(new RemoteNode(node, repo, configName));
                }
                return remotes.toArray();
            }
            case REPO: {
                ArrayList<RepositoryTreeNode> nodeList = new ArrayList<RepositoryTreeNode>();
                nodeList.add(new BranchesNode(node, repo));
                nodeList.add(new TagsNode(node, repo));
                nodeList.add(new AdditionalRefsNode(node, repo));
                boolean bare = repo.isBare();
                if (!bare) {
                    nodeList.add(new WorkingDirNode(node, repo));
                }
                nodeList.add(new RemotesNode(node, repo));
                if (!bare && this.hasStashedCommits(repo)) {
                    nodeList.add(new StashNode(node, repo));
                }
                if (!bare && this.hasConfiguredSubmodules(repo)) {
                    nodeList.add(new SubmodulesNode(node, repo));
                }
                return nodeList.toArray();
            }
            case WORKINGDIR: {
                ArrayList<RepositoryTreeNode> children = new ArrayList<RepositoryTreeNode>();
                if (node.getRepository().isBare()) {
                    return children.toArray();
                }
                File workingDir = repo.getWorkTree();
                if (workingDir == null || !workingDir.exists()) {
                    return children.toArray();
                }
                File[] childFiles = workingDir.listFiles();
                Arrays.sort(childFiles, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        if (o1.isDirectory()) {
                            if (o2.isDirectory()) {
                                return o1.compareTo(o2);
                            }
                            return -1;
                        }
                        if (o2.isDirectory()) {
                            return 1;
                        }
                        return o1.compareTo(o2);
                    }
                });
                File[] fileArray = childFiles;
                int n = childFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.isDirectory()) {
                        children.add(new FolderNode(node, repo, file));
                    } else {
                        children.add(new FileNode(node, repo, file));
                    }
                    ++n2;
                }
                return children.toArray();
            }
            case FOLDER: {
                ArrayList<RepositoryTreeNode> children = new ArrayList<RepositoryTreeNode>();
                File parent = (File)node.getObject();
                File[] childFiles = parent.listFiles();
                if (childFiles == null) {
                    return children.toArray();
                }
                Arrays.sort(childFiles, new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        if (o1.isDirectory()) {
                            if (o2.isDirectory()) {
                                return o1.compareTo(o2);
                            }
                            return -1;
                        }
                        if (o2.isDirectory()) {
                            return 1;
                        }
                        return o1.compareTo(o2);
                    }
                });
                File[] fileArray = childFiles;
                int n = childFiles.length;
                int n3 = 0;
                while (n3 < n) {
                    File file = fileArray[n3];
                    if (file.isDirectory()) {
                        children.add(new FolderNode(node, repo, file));
                    } else {
                        children.add(new FileNode(node, repo, file));
                    }
                    ++n3;
                }
                return children.toArray();
            }
            case REMOTE: {
                int uriCount;
                RemoteConfig rc;
                ArrayList<RepositoryTreeNode> children = new ArrayList<RepositoryTreeNode>();
                String remoteName = (String)node.getObject();
                try {
                    rc = new RemoteConfig((Config)node.getRepository().getConfig(), remoteName);
                }
                catch (URISyntaxException e) {
                    return this.handleException(e, node);
                }
                if (!rc.getURIs().isEmpty()) {
                    children.add(new FetchNode(node, node.getRepository(), ((URIish)rc.getURIs().get(0)).toPrivateString()));
                }
                if ((uriCount = rc.getPushURIs().size()) == 0 && !rc.getURIs().isEmpty()) {
                    ++uriCount;
                }
                if (uriCount > 0) {
                    URIish firstUri = !rc.getPushURIs().isEmpty() ? (URIish)rc.getPushURIs().get(0) : (URIish)rc.getURIs().get(0);
                    if (uriCount == 1) {
                        children.add(new PushNode(node, node.getRepository(), firstUri.toPrivateString()));
                    } else {
                        children.add(new PushNode(node, node.getRepository(), String.valueOf(firstUri.toPrivateString()) + "..."));
                    }
                }
                return children.toArray();
            }
            case SUBMODULES: {
                ArrayList<RepositoryNode> children = new ArrayList<RepositoryNode>();
                try {
                    SubmoduleWalk walk = SubmoduleWalk.forIndex((Repository)node.getRepository());
                    while (walk.next()) {
                        Repository subRepo = walk.getRepository();
                        if (subRepo == null) continue;
                        Repository cachedRepo = null;
                        try {
                            cachedRepo = this.repositoryCache.lookupRepository(subRepo.getDirectory());
                        }
                        finally {
                            subRepo.close();
                        }
                        if (cachedRepo == null) continue;
                        children.add(new RepositoryNode(node, cachedRepo));
                    }
                }
                catch (IOException e) {
                    this.handleException(e, node);
                }
                return children.toArray();
            }
            case STASH: {
                ArrayList<StashedCommitNode> stashNodes = new ArrayList<StashedCommitNode>();
                int index = 0;
                try {
                    for (RevCommit commit : Git.wrap((Repository)repo).stashList().call()) {
                        stashNodes.add(new StashedCommitNode(node, repo, index++, commit));
                    }
                }
                catch (Exception e) {
                    this.handleException(e, node);
                }
                return stashNodes.toArray();
            }
            case REF: 
            case ADDITIONALREF: 
            case TAG: 
            case FILE: 
            case FETCH: 
            case PUSH: 
            case STASHED_COMMIT: 
            case ERROR: {
                return null;
            }
        }
        return null;
    }

    private Object[] getTagsChildren(RepositoryTreeNode parentNode, Repository repo) {
        ArrayList<TagNode> nodes = new ArrayList<TagNode>();
        RevWalk walk = new RevWalk(repo);
        walk.setRetainBody(true);
        try {
            try {
                Map<String, Ref> tagRefs = this.getRefs(repo, "refs/tags/");
                for (Ref tagRef : tagRefs.values()) {
                    ObjectId objectId = tagRef.getLeaf().getObjectId();
                    RevObject revObject = walk.parseAny((AnyObjectId)objectId);
                    RevObject peeledObject = walk.peel(revObject);
                    TagNode tagNode = this.createTagNode(parentNode, repo, tagRef, revObject, peeledObject);
                    nodes.add(tagNode);
                }
            }
            catch (IOException e) {
                Object[] objectArray = this.handleException(e, parentNode);
                walk.release();
                return objectArray;
            }
        }
        finally {
            walk.release();
        }
        return nodes.toArray();
    }

    private TagNode createTagNode(RepositoryTreeNode parentNode, Repository repo, Ref ref, RevObject revObject, RevObject peeledObject) {
        boolean annotated = revObject instanceof RevTag;
        if (peeledObject instanceof RevCommit) {
            RevCommit commit = (RevCommit)peeledObject;
            String id = commit.getId().name();
            String message = commit.getShortMessage();
            return new TagNode(parentNode, repo, ref, annotated, id, message);
        }
        return new TagNode(parentNode, repo, ref, annotated, "", "");
    }

    private Object[] handleException(Exception e, RepositoryTreeNode parentNode) {
        Activator.handleError(e.getMessage(), e, false);
        String message = e.getMessage();
        if (message == null) {
            return new Object[]{new ErrorNode(parentNode, parentNode.getRepository(), UIText.RepositoriesViewContentProvider_ExceptionNodeText)};
        }
        return new Object[]{new ErrorNode(parentNode, parentNode.getRepository(), message)};
    }

    public Object getParent(Object element) {
        if (element instanceof RepositoryTreeNode) {
            return ((RepositoryTreeNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        RepositoryTreeNode node = (RepositoryTreeNode)element;
        Repository repo = node.getRepository();
        switch (node.getType()) {
            case BRANCHES: {
                return true;
            }
            case REPO: {
                return true;
            }
            case ADDITIONALREFS: {
                return true;
            }
            case SUBMODULES: {
                return true;
            }
            case TAGS: {
                try {
                    return !this.getRefs(repo, "refs/tags/").isEmpty();
                }
                catch (IOException iOException) {
                    return true;
                }
            }
            case WORKINGDIR: {
                if (node.getRepository().isBare()) {
                    return false;
                }
                File workingDir = repo.getWorkTree();
                if (workingDir == null || !workingDir.exists()) {
                    return false;
                }
                return workingDir.listFiles().length > 0;
            }
        }
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public void handleStateChange(State state, Object oldValue) {
        try {
            this.branchHierarchyMode = (Boolean)state.getValue();
        }
        catch (Exception e) {
            Activator.handleError(e.getMessage(), e, false);
        }
    }

    private synchronized Map<String, Ref> getRefs(final Repository repo, String prefix) throws IOException {
        Map allRefs = this.branchRefs.get(repo);
        if (allRefs == null) {
            allRefs = repo.getRefDatabase().getRefs("");
            this.branchRefs.put(repo, allRefs);
            if (this.refsChangedListeners.get(repo) == null) {
                RefsChangedListener listener = new RefsChangedListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onRefsChanged(RefsChangedEvent event) {
                        RepositoriesViewContentProvider repositoriesViewContentProvider = RepositoriesViewContentProvider.this;
                        synchronized (repositoriesViewContentProvider) {
                            RepositoriesViewContentProvider.this.branchRefs.remove(repo);
                        }
                    }
                };
                this.refsChangedListeners.put(repo, repo.getListenerList().addRefsChangedListener(listener));
            }
        }
        if (prefix.equals("")) {
            return allRefs;
        }
        HashMap<String, Ref> filtered = new HashMap<String, Ref>();
        for (Map.Entry entry : allRefs.entrySet()) {
            if (!((String)entry.getKey()).startsWith(prefix)) continue;
            filtered.put((String)entry.getKey(), (Ref)entry.getValue());
        }
        return filtered;
    }

    private boolean hasConfiguredSubmodules(Repository repository) {
        if (new File(repository.getWorkTree(), ".gitmodules").isFile()) {
            return true;
        }
        return !repository.getConfig().getSubsections("submodule").isEmpty();
    }

    private boolean hasStashedCommits(Repository repository) {
        try {
            return repository.getRef("refs/stash") != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

