/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.File;
import java.util.Iterator;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.GitCompareFileRevisionEditorInput;
import org.eclipse.egit.ui.internal.dialogs.CompareTreeView;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareVersionsInTreeHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = this.getSelection(event);
        if (selection.size() == 2) {
            Iterator it = selection.iterator();
            RevCommit commit1 = (RevCommit)it.next();
            RevCommit commit2 = (RevCommit)it.next();
            HistoryPageInput pageInput = this.getPage(event).getInputInternal();
            Object input = pageInput.getSingleItem();
            Repository repository = pageInput.getRepository();
            IWorkbenchPage workBenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
            if (input instanceof IFile) {
                IFile resource = (IFile)input;
                RepositoryMapping map = RepositoryMapping.getMapping((IResource)resource);
                String gitPath = map.getRepoRelativePath((IResource)resource);
                ITypedElement base = CompareUtils.getFileRevisionTypedElement(gitPath, commit1, map.getRepository());
                ITypedElement next = CompareUtils.getFileRevisionTypedElement(gitPath, commit2, map.getRepository());
                GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, next, null);
                CompareUtils.openInCompare(workBenchPage, (CompareEditorInput)in);
            } else if (input instanceof File) {
                File fileInput = (File)input;
                Repository repo = this.getRepository(event);
                String gitPath = this.getRepoRelativePath(repo, fileInput);
                ITypedElement base = CompareUtils.getFileRevisionTypedElement(gitPath, commit1, repo);
                ITypedElement next = CompareUtils.getFileRevisionTypedElement(gitPath, commit2, repo);
                GitCompareFileRevisionEditorInput in = new GitCompareFileRevisionEditorInput(base, next, null);
                CompareUtils.openInCompare(workBenchPage, (CompareEditorInput)in);
            } else if (input instanceof IResource) {
                try {
                    CompareTreeView view = (CompareTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.CompareTreeView");
                    view.setInput(new IResource[]{(IResource)input}, commit1.getId().name(), commit2.getId().name());
                }
                catch (PartInitException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
            } else if (input == null) {
                try {
                    CompareTreeView view = (CompareTreeView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.egit.ui.CompareTreeView");
                    view.setInput(repository, commit1.getId().name(), commit2.getId().name());
                }
                catch (PartInitException e) {
                    Activator.handleError(e.getMessage(), e, true);
                }
            }
        }
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        return this.getSelection(page).size() == 2;
    }
}

