/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.source;

import java.io.File;
import java.io.FileReader;
import java.util.List;
import java.util.Properties;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.apache.maven.archetype.source.ArchetypeDataSourceException;
import org.apache.maven.archetype.source.CatalogArchetypeDataSource;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.repository.Repository;

public class RemoteCatalogArchetypeDataSource
extends CatalogArchetypeDataSource {
    private WagonManager wagonManager;
    public static String REPOSITORY_PROPERTY = "repository";

    public ArchetypeCatalog getArchetypeCatalog(Properties properties) throws ArchetypeDataSourceException {
        String repository = properties.getProperty(REPOSITORY_PROPERTY);
        if (repository == null) {
            throw new ArchetypeDataSourceException("To use the remote catalog you must specify the 'repository' property with an URL.");
        }
        try {
            if (repository.endsWith("/")) {
                repository = repository.substring(0, repository.length() - 1);
            }
            this.getLogger().debug("Searching for remote catalog: " + repository + "/archetype-catalog.xml");
            Repository wagonRepository = new Repository("archetype", repository);
            Wagon wagon = this.wagonManager.getWagon(wagonRepository);
            File catalog = File.createTempFile("archetype-catalog", ".xml");
            wagon.connect(wagonRepository);
            wagon.get("archetype-catalog.xml", catalog);
            wagon.disconnect();
            return this.readCatalog(new FileReader(catalog));
        }
        catch (ArchetypeDataSourceException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                String repositoryPath = repository.substring(0, repository.lastIndexOf("/"));
                String fileName = repository.substring(repository.lastIndexOf("/") + 1);
                this.getLogger().debug("Searching for remote catalog: " + repositoryPath + "/" + fileName);
                Repository wagonRepository = new Repository("archetype", repositoryPath);
                Wagon wagon = this.wagonManager.getWagon(wagonRepository);
                File catalog = File.createTempFile("archetype-catalog", ".xml");
                wagon.connect(wagonRepository);
                wagon.get(fileName, catalog);
                wagon.disconnect();
                return this.readCatalog(new FileReader(catalog));
            }
            catch (Exception ex) {
                this.getLogger().warn("Error reading archetype catalog " + repository, (Throwable)ex);
                return new ArchetypeCatalog();
            }
        }
    }

    public List getArchetypes(Properties properties) throws ArchetypeDataSourceException {
        String repository = properties.getProperty(REPOSITORY_PROPERTY);
        if (repository == null) {
            throw new ArchetypeDataSourceException("To use the remote catalog you must specify the 'remote-catalog.repository' property correctly in your ~/.m2/archetype-catalog.properties file.");
        }
        try {
            if (repository.endsWith("/")) {
                repository = repository.substring(0, repository.length() - 1);
            }
            Repository wagonRepository = new Repository("archetype", repository);
            Wagon wagon = this.wagonManager.getWagon(wagonRepository);
            File catalog = File.createTempFile("archetype-catalog", ".xml");
            wagon.connect(wagonRepository);
            wagon.get("archetype-catalog.xml", catalog);
            wagon.disconnect();
            return this.createArchetypeMap(this.readCatalog(new FileReader(catalog)));
        }
        catch (Exception e) {
            throw new ArchetypeDataSourceException("Error reading archetype registry.", e);
        }
    }

    public void updateCatalog(Properties properties, Archetype archetype) throws ArchetypeDataSourceException {
        throw new ArchetypeDataSourceException("Not supported yet.");
    }
}

