/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.wizards.actions;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.wizards.actions.AbstractOpenWizardAction;

public class OpenTypeWizardAction
extends AbstractOpenWizardAction {
    private static final String ATT_NAME = "name";
    private static final String ATT_ICON = "icon";
    private static final String ATT_CLASS = "class";
    private static final String TAG_DESCRIPTION = "description";
    private final IConfigurationElement fConfigurationElement;

    public OpenTypeWizardAction(IConfigurationElement element) {
        this.fConfigurationElement = element;
        this.setText(element.getAttribute(ATT_NAME));
        this.setImageDescriptor(this.getIconFromConfig(this.fConfigurationElement));
        String description = this.getDescriptionFromConfig(this.fConfigurationElement);
        this.setDescription(description);
        this.setToolTipText(description);
    }

    private String getDescriptionFromConfig(IConfigurationElement config) {
        IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            return children[0].getValue();
        }
        return "";
    }

    private ImageDescriptor getIconFromConfig(IConfigurationElement config) {
        try {
            return ExternalFactoriesHelper.getImageDescriptor((IConfigurationElement)config, (String)ATT_ICON);
        }
        catch (Throwable e) {
            DesignerPlugin.log((String)"Unable to load wizard icon", (Throwable)e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    protected Wizard createWizard() {
        try {
            return (Wizard)this.fConfigurationElement.createExecutableExtension(ATT_CLASS);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

