/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.rcp.utils;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.LocalVariable;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.recommenders.rcp.utils.RCPUtils;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.Names;
import org.eclipse.recommenders.utils.names.VmTypeName;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdtUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JdtUtils.class);
    private static final Util.BindingsToNodesMap EMPTY_NODE_MAP = new Util.BindingsToNodesMap(){

        public org.eclipse.jdt.internal.compiler.ast.ASTNode get(Binding binding) {
            return null;
        }
    };
    private static final Predicate<IField> STATIC_PUBLIC_FIELDS_ONLY_FILTER = new Predicate<IField>(){

        public boolean apply(IField m) {
            try {
                return !JdtFlags.isStatic((IMember)m) || !JdtFlags.isPublic((IMember)m);
            }
            catch (Exception exception) {
                return true;
            }
        }
    };
    private static final Predicate<IField> PUBLIC_FIELDS_ONLY_FILTER = new Predicate<IField>(){

        public boolean apply(IField m) {
            try {
                return JdtFlags.isStatic((IMember)m) || !JdtFlags.isPublic((IMember)m);
            }
            catch (Exception exception) {
                return true;
            }
        }
    };
    private static final Predicate<IMethod> STATIC_PUBLIC_METHODS_ONLY_FILTER = new Predicate<IMethod>(){

        public boolean apply(IMethod m) {
            try {
                return !JdtFlags.isStatic((IMember)m) || !JdtFlags.isPublic((IMember)m);
            }
            catch (Exception exception) {
                return true;
            }
        }
    };
    private static final Predicate<IMethod> PUBLIC_INSTANCE_METHODS_ONLY_FILTER = new Predicate<IMethod>(){

        public boolean apply(IMethod m) {
            try {
                return JdtFlags.isStatic((IMember)m) || !JdtFlags.isPublic((IMember)m) || m.isConstructor();
            }
            catch (Exception exception) {
                return true;
            }
        }
    };
    private static final Predicate<IMethod> STATIC_NON_VOID_NON_PRIMITIVE_PUBLIC_METHODS_FILTER = new Predicate<IMethod>(){

        public boolean apply(IMethod m) {
            try {
                return !JdtFlags.isStatic((IMember)m) || JdtUtils.isVoid(m) || !JdtFlags.isPublic((IMember)m) || JdtUtils.hasPrimitiveReturnType(m);
            }
            catch (Exception exception) {
                return true;
            }
        }
    };

    private static String createFieldKey(IField field) {
        try {
            return String.valueOf(field.getElementName()) + field.getTypeSignature();
        }
        catch (Exception e) {
            throw Throws.throwUnhandledException((Exception)e);
        }
    }

    private static String createMethodKey(IMethod method) {
        try {
            String signature = method.getSignature();
            String signatureWithoutReturnType = StringUtils.substringBeforeLast((String)signature, (String)")");
            String methodName = method.getElementName();
            return String.valueOf(methodName) + signatureWithoutReturnType;
        }
        catch (Exception e) {
            throw Throws.throwUnhandledException((Exception)e);
        }
    }

    public static IRegion createRegion(ASTNode node) {
        Checks.ensureIsNotNull((Object)node);
        return new Region(node.getStartPosition(), node.getLength());
    }

    public static Optional<IField> createUnresolvedField(FieldBinding compilerBinding) {
        Checks.ensureIsNotNull((Object)compilerBinding);
        IField f = (IField)Util.getUnresolvedJavaElement((FieldBinding)compilerBinding, null, (Util.BindingsToNodesMap)EMPTY_NODE_MAP);
        return Optional.fromNullable((Object)f);
    }

    public static ILocalVariable createUnresolvedLocaVariable(VariableBinding compilerBinding, JavaElement parent) {
        Checks.ensureIsNotNull((Object)compilerBinding);
        Checks.ensureIsNotNull((Object)parent);
        String name = new String(compilerBinding.name);
        String type = new String(compilerBinding.type.signature());
        return new LocalVariable(parent, name, 0, 0, 0, 0, type, null, compilerBinding.modifiers, compilerBinding.isParameter());
    }

    public static Optional<IMethod> createUnresolvedMethod(MethodBinding compilerBinding) {
        Checks.ensureIsNotNull((Object)compilerBinding);
        IMethod m = (IMethod)Util.getUnresolvedJavaElement((MethodBinding)compilerBinding, null, (Util.BindingsToNodesMap)EMPTY_NODE_MAP);
        return Optional.fromNullable((Object)m);
    }

    public static Optional<IType> createUnresolvedType(TypeBinding compilerBinding) {
        JavaElement e = Util.getUnresolvedJavaElement((TypeBinding)compilerBinding, null, (Util.BindingsToNodesMap)EMPTY_NODE_MAP);
        if (e instanceof IType) {
            return Optional.of((Object)((IType)e));
        }
        if (e instanceof ITypeParameter) {
            return JdtUtils.resolveTypeParameter((ITypeParameter)e);
        }
        return Optional.absent();
    }

    private static Optional<IType> resolveTypeParameter(ITypeParameter t) {
        IType type = null;
        try {
            IJavaProject project = t.getJavaProject();
            Object[] bounds = t.getBoundsSignatures();
            if (ArrayUtils.isEmpty((Object[])bounds)) {
                type = project.findType("java.lang.Object");
            } else {
                IMember declaringMember = t.getDeclaringMember();
                Optional<String> typename = JdtUtils.resolveUnqualifiedTypeNamesAndStripOffGenericsAndArrayDimension((String)bounds[0], (IJavaElement)declaringMember);
                if (typename.isPresent()) {
                    type = project.findType((String)typename.get());
                }
            }
        }
        catch (Exception e) {
            LOG.error("Failed to resolve type parameter {}", (Object)t.getElementName(), (Object)e);
        }
        return Optional.fromNullable(type);
    }

    public static Collection<IMember> findAllPublicInstanceFieldsAndNonVoidNonPrimitiveInstanceMethods(IType type) {
        LinkedHashMap<String, IMethod> tmp = new LinkedHashMap<String, IMethod>();
        try {
            IType[] returnTypeAndSupertypes;
            IType[] iTypeArray = returnTypeAndSupertypes = JdtUtils.findAllSupertypesIncludeingArgument(type);
            int n = returnTypeAndSupertypes.length;
            int n2 = 0;
            while (n2 < n) {
                String key;
                IType cur = iTypeArray[n2];
                IMethod[] iMethodArray = cur.getMethods();
                int n3 = iMethodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMethod m = iMethodArray[n4];
                    if (!(JdtUtils.isVoid(m) || !JdtFlags.isPublic((IMember)m) || m.isConstructor() || JdtFlags.isStatic((IMember)m) || JdtUtils.hasPrimitiveReturnType(m) || tmp.containsKey(key = JdtUtils.createMethodKey(m)))) {
                        tmp.put(key, m);
                    }
                    ++n4;
                }
                iMethodArray = cur.getFields();
                n3 = iMethodArray.length;
                n4 = 0;
                while (n4 < n3) {
                    IMethod field = iMethodArray[n4];
                    if (JdtFlags.isPublic((IMember)field) && !JdtFlags.isStatic((IMember)field) && !tmp.containsKey(key = JdtUtils.createFieldKey((IField)field))) {
                        tmp.put(key, field);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            JdtUtils.log(e);
        }
        return tmp.values();
    }

    public static Collection<IMember> findAllPublicInstanceFieldsAndPublicInstanceMethods(IType type) {
        return JdtUtils.findAllRelevanFieldsAndMethods(type, PUBLIC_FIELDS_ONLY_FILTER, PUBLIC_INSTANCE_METHODS_ONLY_FILTER);
    }

    public static Collection<IMember> findAllPublicStaticFieldsAndNonVoidNonPrimitiveStaticMethods(IType type) {
        return JdtUtils.findAllRelevanFieldsAndMethods(type, STATIC_PUBLIC_FIELDS_ONLY_FILTER, STATIC_NON_VOID_NON_PRIMITIVE_PUBLIC_METHODS_FILTER);
    }

    public static Collection<IMember> findAllRelevanFieldsAndMethods(IType type, Predicate<IField> fieldFilter, Predicate<IMethod> methodFilter) {
        LinkedHashMap<String, IMethod> tmp = new LinkedHashMap<String, IMethod>();
        IType[] iTypeArray = JdtUtils.findAllSupertypesIncludeingArgument(type);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType cur = iTypeArray[n2];
            try {
                String key;
                IMethod[] iMethodArray = cur.getMethods();
                int n3 = iMethodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMethod method = iMethodArray[n4];
                    if (!methodFilter.apply((Object)method) && !tmp.containsKey(key = JdtUtils.createMethodKey(method))) {
                        tmp.put(key, method);
                    }
                    ++n4;
                }
                iMethodArray = cur.getFields();
                n3 = iMethodArray.length;
                n4 = 0;
                while (n4 < n3) {
                    IMethod field = iMethodArray[n4];
                    if (!fieldFilter.apply((Object)field) && !tmp.containsKey(key = JdtUtils.createFieldKey((IField)field))) {
                        tmp.put(key, field);
                    }
                    ++n4;
                }
            }
            catch (Exception e) {
                JdtUtils.log(e);
            }
            ++n2;
        }
        return tmp.values();
    }

    public static Collection<IMember> findAllPublicStaticFieldsAndStaticMethods(IType type) {
        return JdtUtils.findAllRelevanFieldsAndMethods(type, STATIC_PUBLIC_FIELDS_ONLY_FILTER, STATIC_PUBLIC_METHODS_ONLY_FILTER);
    }

    private static IType[] findAllSupertypesIncludeingArgument(IType returnType) {
        try {
            ITypeHierarchy typeHierarchy = SuperTypeHierarchyCache.getTypeHierarchy((IType)returnType);
            Object[] allSupertypes = typeHierarchy.getAllSupertypes(returnType);
            return (IType[])ArrayUtils.add((Object[])allSupertypes, (int)0, (Object)returnType);
        }
        catch (Exception e) {
            JdtUtils.log(e);
            return new IType[0];
        }
    }

    public static ASTNode findClosestMethodOrTypeDeclarationAroundOffset(CompilationUnit cuNode, ITextSelection selection) {
        Checks.ensureIsNotNull((Object)cuNode);
        Checks.ensureIsNotNull((Object)selection);
        ASTNode node = org.eclipse.jdt.internal.corext.dom.NodeFinder.perform((ASTNode)cuNode, (int)selection.getOffset(), (int)selection.getLength());
        while (node != null) {
            switch (node.getNodeType()) {
                case 31: 
                case 55: {
                    return node;
                }
            }
            node = node.getParent();
        }
        return cuNode;
    }

    public static IMethod findFirstDeclaration(IMethod method) {
        Optional<IMethod> oFind;
        IMethod res = method;
        while ((oFind = JdtUtils.findOverriddenMethod(res)).isPresent()) {
            res = (IMethod)oFind.get();
        }
        return res;
    }

    public static Optional<IMethod> findOverriddenMethod(IMethod jdtMethod) {
        try {
            IType jdtDeclaringType = jdtMethod.getDeclaringType();
            MethodOverrideTester methodOverrideTester = SuperTypeHierarchyCache.getMethodOverrideTester((IType)jdtDeclaringType);
            IMethod overriddenMethod = methodOverrideTester.findOverriddenMethod(jdtMethod, false);
            return Optional.fromNullable((Object)overriddenMethod);
        }
        catch (Exception e) {
            JdtUtils.log(e);
            return Optional.absent();
        }
    }

    public static Optional<ITypeName> findSuperclassName(IType type) {
        try {
            String superclassName = type.getSuperclassTypeSignature();
            if (superclassName == null) {
                return Optional.absent();
            }
            Optional<String> opt = JdtUtils.resolveUnqualifiedTypeNamesAndStripOffGenericsAndArrayDimension(superclassName, (IJavaElement)type);
            if (!opt.isPresent()) {
                return Optional.absent();
            }
            String vmSuperclassName = JdtUtils.toVMTypeDescriptor((String)opt.get());
            VmTypeName vmTypeName = VmTypeName.get((String)vmSuperclassName);
            return Optional.of((Object)vmTypeName);
        }
        catch (Exception e) {
            JdtUtils.log(e);
            return Optional.absent();
        }
    }

    public static Optional<ITypeName> resolveUnqualifiedJDTType(String qName, IJavaElement parent) {
        try {
            qName = Signature.getTypeErasure((String)qName);
            qName = StringUtils.removeEnd((String)qName, (String)";");
            int dimensions = Signature.getArrayCount((String)qName);
            if (dimensions > 0) {
                qName = Signature.getElementType((String)qName);
            }
            if (JdtUtils.isPrimitiveTypeSignature(qName)) {
                VmTypeName t = VmTypeName.get((String)(String.valueOf(StringUtils.repeat((char)'[', (int)dimensions)) + qName));
                return Optional.of((Object)t);
            }
            IType type = JdtUtils.findClosestTypeOrThis(parent);
            if (type == null) {
                return Optional.absent();
            }
            if (qName.charAt(0) == 'T') {
                String literal = String.valueOf(StringUtils.repeat((char)'[', (int)dimensions)) + VmTypeName.OBJECT.getIdentifier();
                VmTypeName name = VmTypeName.get((String)literal);
                return Optional.of((Object)name);
            }
            if (qName.charAt(0) == 'Q') {
                String[][] resolvedNames = type.resolveType(qName.substring(1));
                if (resolvedNames == null || resolvedNames.length == 0) {
                    return Optional.of((Object)VmTypeName.OBJECT);
                }
                String pkg = resolvedNames[0][0];
                String name = resolvedNames[0][1].replace('.', '$');
                qName = String.valueOf(StringUtils.repeat((char)'[', (int)dimensions)) + 'L' + pkg + '.' + name;
            }
            qName = qName.replace('.', '/');
            VmTypeName typeName = VmTypeName.get((String)qName);
            return Optional.of((Object)typeName);
        }
        catch (Exception e) {
            JdtUtils.log(e);
            return Optional.absent();
        }
    }

    private static String toVMTypeDescriptor(String fqjdtName) {
        return fqjdtName == null ? "Ljava/lang/Object" : String.valueOf('L') + fqjdtName.replace('.', '/');
    }

    public static Optional<IType> findSuperclass(IType type) {
        Checks.ensureIsNotNull((Object)type);
        try {
            String superclassTypeSignature = type.getSuperclassTypeSignature();
            if (superclassTypeSignature == null) {
                return Optional.absent();
            }
            return JdtUtils.findTypeFromSignature(superclassTypeSignature, (IJavaElement)type);
        }
        catch (Exception e) {
            JdtUtils.log(e);
            return Optional.absent();
        }
    }

    public static Optional<IType> findTypeFromSignature(String typeSignature, IJavaElement parent) {
        Checks.ensureIsNotNull((Object)typeSignature);
        Checks.ensureIsNotNull((Object)parent);
        try {
            Optional<String> opt = JdtUtils.resolveUnqualifiedTypeNamesAndStripOffGenericsAndArrayDimension(typeSignature, parent);
            if (!opt.isPresent()) {
                return Optional.absent();
            }
            IType res = parent.getJavaProject().findType((String)opt.get());
            return Optional.fromNullable((Object)res);
        }
        catch (Exception e) {
            JdtUtils.log(e);
            return Optional.absent();
        }
    }

    public static Optional<IType> findTypeOfField(IField field) {
        try {
            return JdtUtils.findTypeFromSignature(field.getTypeSignature(), (IJavaElement)field);
        }
        catch (Exception e) {
            JdtUtils.log(e);
            return Optional.absent();
        }
    }

    public static Optional<ITypeRoot> findTypeRoot(IEditorPart editor) {
        ITypeRoot root = EditorUtility.getEditorInputJavaElement((IEditorPart)editor, (boolean)true);
        return Optional.fromNullable((Object)root);
    }

    public static Optional<JavaEditor> getActiveJavaEditor() {
        IEditorPart editor;
        Optional<IWorkbenchPage> page = RCPUtils.getActiveWorkbenchPage();
        if (page.isPresent() && (editor = ((IWorkbenchPage)page.get()).getActiveEditor()) instanceof JavaEditor) {
            return Optional.of((Object)((JavaEditor)editor));
        }
        return Optional.absent();
    }

    public static boolean hasPrimitiveReturnType(IMethod method) {
        try {
            return !method.getReturnType().endsWith(";");
        }
        catch (Exception e) {
            throw Throws.throwUnhandledException((Exception)e);
        }
    }

    public static boolean isAssignable(IType lhsType, IType rhsType) {
        IType[] supertypes;
        Checks.ensureIsNotNull((Object)lhsType);
        Checks.ensureIsNotNull((Object)rhsType);
        IType[] iTypeArray = supertypes = JdtUtils.findAllSupertypesIncludeingArgument(rhsType);
        int n = supertypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType supertype = iTypeArray[n2];
            if (supertype.equals(lhsType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isVoid(IMethod method) {
        try {
            return "V".equals(method.getReturnType());
        }
        catch (Exception e) {
            throw Throws.throwUnhandledException((Exception)e);
        }
    }

    public static void log(Exception e) {
        LOG.error("Exception occurred.", (Throwable)e);
    }

    public static Optional<IMethod> resolveMethod(MethodDeclaration node) {
        if (node == null) {
            return Optional.absent();
        }
        IMethodBinding b = node.resolveBinding();
        if (b == null) {
            return Optional.absent();
        }
        IMethod method = (IMethod)Checks.cast((Object)b.getJavaElement());
        return Optional.fromNullable((Object)method);
    }

    public static <T extends IJavaElement> T resolveJavaElementProxy(IJavaElement element) {
        return (T)element.getPrimaryElement();
    }

    public static Optional<String> resolveUnqualifiedTypeNamesAndStripOffGenericsAndArrayDimension(String typeSignature, IJavaElement parent) {
        Checks.ensureIsNotNull((Object)typeSignature);
        Checks.ensureIsNotNull((Object)parent);
        typeSignature = Signature.getTypeErasure((String)typeSignature);
        if (JdtUtils.isPrimitiveTypeSignature(typeSignature)) {
            return Optional.of((Object)Names.vm2srcTypeName((String)typeSignature));
        }
        try {
            String resolvedTypeSignature;
            typeSignature = typeSignature.replace('/', '.');
            IType type = JdtUtils.findClosestTypeOrThis(parent);
            if (type == null) {
                Throws.throwIllegalArgumentException((String)"parent could not be resolved to an IType: %s", (Object[])new Object[]{parent});
            }
            if ((resolvedTypeSignature = JavaModelUtil.getResolvedTypeName((String)typeSignature, (IType)type)) == null) {
                return Optional.of((Object)"java.lang.Object");
            }
            return Optional.of((Object)resolvedTypeSignature);
        }
        catch (Exception e) {
            JdtUtils.log(e);
            return Optional.absent();
        }
    }

    private static IType findClosestTypeOrThis(IJavaElement parent) {
        return (IType)(parent instanceof IType ? parent : parent.getAncestor(7));
    }

    private static boolean isPrimitiveTypeSignature(String typeSignature) {
        return typeSignature.length() == 1;
    }

    public static Optional<ASTNode> findAstNodeFromEditorSelection(JavaEditor editor, ITextSelection textSelection) {
        Optional<ITypeRoot> root = JdtUtils.findTypeRoot((IEditorPart)editor);
        if (!root.isPresent()) {
            return Optional.absent();
        }
        CompilationUnit astRoot = SharedASTProvider.getAST((ITypeRoot)((ITypeRoot)root.get()), (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
        if (astRoot == null) {
            return Optional.absent();
        }
        ASTNode node = NodeFinder.perform((ASTNode)astRoot, (int)textSelection.getOffset(), (int)0);
        return Optional.fromNullable((Object)node);
    }

    public static Optional<File> getLocation(IJavaProject javaProject) {
        if (javaProject == null) {
            return Optional.absent();
        }
        IProject project = javaProject.getProject();
        IPath location = project.getLocation();
        if (location == null) {
            return Optional.absent();
        }
        File file = location.toFile().getAbsoluteFile();
        if (file.exists()) {
            return Optional.of((Object)file);
        }
        return Optional.absent();
    }

    public static Optional<File> getLocation(IPackageFragmentRoot packageRoot) {
        if (packageRoot == null) {
            return Optional.absent();
        }
        File res = null;
        IResource resource = packageRoot.getResource();
        if (resource != null) {
            res = resource.getLocation() == null ? resource.getRawLocation().toFile().getAbsoluteFile() : resource.getLocation().toFile().getAbsoluteFile();
        }
        if (packageRoot.isExternal()) {
            res = packageRoot.getPath().toFile().getAbsoluteFile();
        }
        if (res != null && !res.exists()) {
            res = null;
        }
        return Optional.fromNullable((Object)res);
    }

    public static boolean isInitializer(IMethod m) {
        return m.getElementName().equals("<clinit>");
    }
}

