/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.ui.internal.launch;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.internal.launch.AbstractMavenRuntime;
import org.eclipse.m2e.core.internal.launch.MavenEmbeddedRuntime;
import org.eclipse.m2e.core.internal.launch.MavenExternalRuntime;
import org.eclipse.m2e.core.internal.launch.MavenRuntimeManagerImpl;
import org.eclipse.m2e.core.internal.launch.MavenWorkspaceRuntime;
import org.eclipse.m2e.internal.launch.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class MavenRuntimeSelector
extends Composite {
    ComboViewer runtimeComboViewer;

    private static MavenRuntimeManagerImpl getRuntimeManager() {
        return MavenPluginActivator.getDefault().getMavenRuntimeManager();
    }

    public MavenRuntimeSelector(final Composite mainComposite) {
        super(mainComposite, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        Label mavenRuntimeLabel = new Label((Composite)this, 0);
        mavenRuntimeLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        mavenRuntimeLabel.setText(Messages.MavenLaunchMainTab_lblRuntime);
        this.runtimeComboViewer = new ComboViewer((Composite)this, 2056);
        this.runtimeComboViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.runtimeComboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object input) {
                return ((List)input).toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        this.runtimeComboViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                AbstractMavenRuntime runtime = (AbstractMavenRuntime)element;
                StringBuilder sb = new StringBuilder();
                if (runtime.isLegacy()) {
                    sb.append("EXTERNAL").append(" ").append(runtime.toString());
                } else if (!runtime.isEditable()) {
                    sb.append(MavenRuntimeSelector.this.getType(runtime)).append(" (").append(runtime.toString()).append(')');
                } else {
                    sb.append(runtime.getName()).append(" (");
                    sb.append(MavenRuntimeSelector.this.getType(runtime)).append(' ').append(runtime.toString());
                    sb.append(')');
                }
                return sb.toString();
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        try {
            this.setInput();
        }
        catch (NullPointerException nullPointerException) {}
        Button configureRuntimesButton = new Button((Composite)this, 0);
        configureRuntimesButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        configureRuntimesButton.setText(Messages.MavenLaunchMainTab_btnConfigure);
        configureRuntimesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)mainComposite.getShell(), (String)"org.eclipse.m2e.core.preferences.MavenInstallationsPreferencePage", null, null);
                if (dialog.open() == 0) {
                    MavenRuntimeSelector.this.setInput();
                }
            }
        });
    }

    protected String getType(AbstractMavenRuntime runtime) {
        if (runtime instanceof MavenEmbeddedRuntime) {
            return "EMBEDDED";
        }
        if (runtime instanceof MavenWorkspaceRuntime) {
            return "WORKSPACE";
        }
        if (runtime instanceof MavenExternalRuntime) {
            return "EXTERNAL";
        }
        throw new IllegalArgumentException();
    }

    protected void setInput() {
        MavenRuntimeManagerImpl runtimeManager = MavenRuntimeSelector.getRuntimeManager();
        this.runtimeComboViewer.setInput((Object)runtimeManager.getMavenRuntimes());
        this.runtimeComboViewer.setSelection((ISelection)new StructuredSelection((Object)runtimeManager.getRuntime("DEFAULT")));
    }

    public void setSelectRuntime(AbstractMavenRuntime runtime) {
        this.runtimeComboViewer.setSelection((ISelection)new StructuredSelection((Object)runtime));
    }

    public AbstractMavenRuntime getSelectedRuntime() {
        IStructuredSelection selection = (IStructuredSelection)this.runtimeComboViewer.getSelection();
        return (AbstractMavenRuntime)selection.getFirstElement();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.runtimeComboViewer.addSelectionChangedListener(listener);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String name = "";
        try {
            name = configuration.getAttribute("M2_RUNTIME", "");
        }
        catch (CoreException coreException) {}
        AbstractMavenRuntime runtime = MavenRuntimeSelector.getRuntimeManager().getRuntime(name);
        if (runtime != null) {
            this.setSelectRuntime(runtime);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        AbstractMavenRuntime runtime = this.getSelectedRuntime();
        configuration.setAttribute("M2_RUNTIME", runtime.getName());
    }
}

