/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.embedder.ICallable;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.internal.embedder.FilterRepositorySystemSession;
import org.eclipse.m2e.core.internal.embedder.MavenImpl;
import org.eclipse.m2e.core.internal.embedder.ReadonlyMavenExecutionRequest;

public class MavenExecutionContext
implements IMavenExecutionContext {
    private static final String CTX_PREFIX = MavenExecutionContext.class.getName();
    private static final String CTX_LOCALREPOSITORY = String.valueOf(CTX_PREFIX) + "/localRepository";
    private static final String CTX_MAVENSESSION = String.valueOf(CTX_PREFIX) + "/mavenSession";
    private static final String CTX_REPOSITORYSESSION = String.valueOf(CTX_PREFIX) + "/repositorySession";
    private static final ThreadLocal<Deque<MavenExecutionContext>> threadLocal = new ThreadLocal();
    private final MavenImpl maven;
    private MavenExecutionRequest request;
    private Map<String, Object> context;

    public MavenExecutionContext(MavenImpl maven) {
        this.maven = maven;
    }

    @Override
    public MavenExecutionRequest getExecutionRequest() throws CoreException {
        if (this.request != null && this.context != null) {
            return new ReadonlyMavenExecutionRequest(this.request);
        }
        if (this.request == null) {
            this.request = this.newExecutionRequest();
        }
        return this.request;
    }

    protected MavenExecutionRequest newExecutionRequest() throws CoreException {
        MavenExecutionRequest request = null;
        Deque<MavenExecutionContext> stack = threadLocal.get();
        if (stack != null && !stack.isEmpty()) {
            MavenExecutionRequest parent = stack.peek().request;
            if (parent == null) {
                throw new IllegalStateException();
            }
            request = DefaultMavenExecutionRequest.copy((MavenExecutionRequest)parent);
        }
        if (request == null) {
            request = this.maven.createExecutionRequest();
        }
        return request;
    }

    @Override
    public <V> V execute(ICallable<V> callable, IProgressMonitor monitor) throws CoreException {
        return this.execute(null, callable, monitor);
    }

    @Override
    public <V> V execute(MavenProject project, ICallable<V> callable, IProgressMonitor monitor) throws CoreException {
        MavenExecutionContext parent;
        Deque<MavenExecutionContext> stack = threadLocal.get();
        if (stack == null) {
            stack = new ArrayDeque<MavenExecutionContext>();
            threadLocal.set(stack);
        }
        if (this == (parent = stack.peek())) {
            return this.executeBare(project, callable, monitor);
        }
        MavenExecutionRequest origRequest = this.request;
        Map<String, Object> origContext = this.context;
        if (this.request == null && parent != null) {
            this.request = parent.request;
            this.context = new HashMap<String, Object>(parent.context);
        } else {
            this.context = new HashMap<String, Object>();
            if (this.request == null) {
                this.request = this.newExecutionRequest();
            }
            this.maven.populateDefaults(this.request);
            MavenExecutionContext.populateSystemProperties(this.request);
            this.setValue(CTX_LOCALREPOSITORY, this.request.getLocalRepository());
            FilterRepositorySystemSession repositorySession = this.maven.createRepositorySession(this.request);
            this.setValue(CTX_REPOSITORYSESSION, repositorySession);
            if (parent != null) {
                repositorySession.setData(parent.getRepositorySession().getData());
            }
            DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
            this.setValue(CTX_MAVENSESSION, new MavenSession(this.maven.getPlexusContainer(), (RepositorySystemSession)repositorySession, this.request, (MavenExecutionResult)result));
        }
        LegacySupport legacySupport = this.maven.lookup(LegacySupport.class);
        MavenSession origLegacySession = legacySupport.getSession();
        stack.push(this);
        legacySupport.setSession(this.getSession());
        try {
            V v = this.executeBare(project, callable, monitor);
            return v;
        }
        finally {
            stack.pop();
            if (stack.isEmpty()) {
                threadLocal.set(null);
            }
            legacySupport.setSession(origLegacySession);
            this.request = origRequest;
            this.context = origContext;
        }
    }

    private <V> V executeBare(MavenProject project, ICallable<V> callable, IProgressMonitor monitor) throws CoreException {
        V v;
        MavenSession mavenSession = this.getSession();
        FilterRepositorySystemSession repositorySession = this.getRepositorySession();
        TransferListener origTransferListener = repositorySession.setTransferListener(this.maven.createArtifactTransferListener(monitor));
        MavenProject origProject = mavenSession.getCurrentProject();
        List origProjects = mavenSession.getProjects();
        try {
            if (project != null) {
                mavenSession.setCurrentProject(project);
                mavenSession.setProjects(Collections.singletonList(project));
            }
            v = callable.call(this, monitor);
            repositorySession.setTransferListener(origTransferListener);
        }
        catch (Throwable throwable) {
            repositorySession.setTransferListener(origTransferListener);
            if (project != null) {
                mavenSession.setCurrentProject(origProject);
                mavenSession.setProjects(origProjects != null ? origProjects : Collections.emptyList());
            }
            throw throwable;
        }
        if (project != null) {
            mavenSession.setCurrentProject(origProject);
            mavenSession.setProjects(origProjects != null ? origProjects : Collections.emptyList());
        }
        return v;
    }

    @Override
    public MavenSession getSession() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return (MavenSession)this.getValue(CTX_MAVENSESSION);
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return (ArtifactRepository)this.getValue(CTX_LOCALREPOSITORY);
    }

    public FilterRepositorySystemSession getRepositorySession() {
        if (this.context == null) {
            throw new IllegalStateException();
        }
        return (FilterRepositorySystemSession)((Object)this.getValue(CTX_REPOSITORYSESSION));
    }

    public static MavenExecutionContext getThreadContext() {
        return MavenExecutionContext.getThreadContext(true);
    }

    public static MavenExecutionContext getThreadContext(boolean innermost) {
        Deque<MavenExecutionContext> stack = threadLocal.get();
        return stack != null ? (innermost ? stack.peekFirst() : stack.peekLast()) : null;
    }

    public static void populateSystemProperties(MavenExecutionRequest request) {
        Properties systemProperties = new Properties();
        EnvironmentUtils.addEnvVars((Properties)systemProperties);
        systemProperties.putAll((Map<?, ?>)System.getProperties());
        request.setSystemProperties(systemProperties);
    }

    @Override
    public ProjectBuildingRequest newProjectBuildingRequest() {
        DefaultProjectBuildingRequest projectBuildingRequest = new DefaultProjectBuildingRequest();
        projectBuildingRequest.setLocalRepository(this.getLocalRepository());
        projectBuildingRequest.setRepositorySession((RepositorySystemSession)this.getRepositorySession());
        projectBuildingRequest.setSystemProperties(this.request.getSystemProperties());
        projectBuildingRequest.setUserProperties(this.request.getUserProperties());
        projectBuildingRequest.setRemoteRepositories(this.request.getRemoteRepositories());
        projectBuildingRequest.setPluginArtifactRepositories(this.request.getPluginArtifactRepositories());
        projectBuildingRequest.setActiveProfileIds(this.request.getActiveProfiles());
        projectBuildingRequest.setInactiveProfileIds(this.request.getInactiveProfiles());
        projectBuildingRequest.setProfiles(this.request.getProfiles());
        projectBuildingRequest.setProcessPlugins(true);
        projectBuildingRequest.setBuildStartTime(this.request.getStartTime());
        return projectBuildingRequest;
    }

    public static Deque<MavenExecutionContext> suspend() {
        Deque<MavenExecutionContext> queue = threadLocal.get();
        threadLocal.set(null);
        return queue;
    }

    public static void resume(Deque<MavenExecutionContext> queue) {
        if (threadLocal.get() != null) {
            throw new IllegalStateException();
        }
        threadLocal.set(queue);
    }

    public <T> T getValue(String key) {
        return (T)this.context.get(key);
    }

    public <T> void setValue(String key, T value) {
        this.context.put(key, value);
    }
}

