/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.overrides.rcp;

import com.google.common.base.Optional;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.recommenders.models.IModelArchiveCoordinateAdvisor;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.rcp.ModelEvents;
import org.eclipse.recommenders.overrides.IOverrideModel;
import org.eclipse.recommenders.overrides.IOverrideModelProvider;
import org.eclipse.recommenders.overrides.PoolingOverrideModelProvider;
import org.eclipse.recommenders.rcp.IRcpService;
import org.eclipse.recommenders.utils.names.ITypeName;

public class RcpOverrideModelProvider
implements IOverrideModelProvider,
IRcpService {
    private final IModelRepository repository;
    private final IModelArchiveCoordinateAdvisor index;
    private PoolingOverrideModelProvider delegate;

    @Inject
    public RcpOverrideModelProvider(IModelRepository repository, IModelArchiveCoordinateAdvisor index) {
        this.repository = repository;
        this.index = index;
    }

    @PostConstruct
    public void open() throws IOException {
        this.delegate = new PoolingOverrideModelProvider(this.repository, this.index);
        this.delegate.open();
    }

    @PreDestroy
    public void close() throws IOException {
        this.delegate.close();
    }

    public Optional<IOverrideModel> acquireModel(IUniqueName<ITypeName> key) {
        return this.delegate.acquireModel(key);
    }

    public void releaseModel(IOverrideModel model) {
        this.delegate.releaseModel((Object)model);
    }

    @Subscribe
    public void onEvent(ModelEvents.ModelRepositoryOpenedEvent e) throws IOException {
        this.open();
    }

    @Subscribe
    public void onEvent(ModelEvents.ModelRepositoryClosedEvent e) throws IOException {
        this.close();
    }
}

