/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipFile;
import org.eclipse.recommenders.models.IModelArchiveCoordinateAdvisor;
import org.eclipse.recommenders.models.IModelProvider;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.eclipse.recommenders.utils.Zips;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleModelProvider<K extends IUniqueName<?>, M>
implements IModelProvider<K, M> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    protected LoadingCache<ModelCoordinate, ZipFile> openZips = CacheBuilder.newBuilder().maximumSize(10L).expireAfterAccess(1L, TimeUnit.MINUTES).removalListener((RemovalListener)new ZipRemovalListener()).build((CacheLoader)new ZipCacheLoader());
    protected IModelRepository repository;
    protected String modelType;
    private IModelArchiveCoordinateAdvisor index;

    public SimpleModelProvider(IModelRepository cache, IModelArchiveCoordinateAdvisor index, String modelType) {
        this.repository = cache;
        this.index = index;
        this.modelType = modelType;
    }

    @Override
    public Optional<M> acquireModel(K key) {
        try {
            ZipFile zip;
            ModelCoordinate mc = (ModelCoordinate)this.index.suggest(key.getProjectCoordinate(), this.modelType).orNull();
            if (mc == null) {
                return Optional.absent();
            }
            try {
                zip = (ZipFile)this.openZips.get((Object)mc);
            }
            catch (UncheckedExecutionException e) {
                if (IllegalStateException.class.equals(e.getCause().getClass())) {
                    return Optional.absent();
                }
                throw e;
            }
            return this.loadModel(zip, key);
        }
        catch (Exception e) {
            this.log.error("Exception while loading model " + key, (Throwable)e);
            return Optional.absent();
        }
    }

    protected abstract Optional<M> loadModel(ZipFile var1, K var2) throws Exception;

    @Override
    public void releaseModel(M value) {
    }

    public void open() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.openZips.invalidateAll();
    }

    private final class ZipCacheLoader
    extends CacheLoader<ModelCoordinate, ZipFile> {
        private ZipCacheLoader() {
        }

        public ZipFile load(ModelCoordinate key) throws Exception {
            File location = (File)SimpleModelProvider.this.repository.getLocation(key, true).get();
            ByteStreams.toByteArray((InputSupplier)Files.newInputStreamSupplier((File)location));
            return new ZipFile(location);
        }
    }

    private final class ZipRemovalListener
    implements RemovalListener<ModelCoordinate, ZipFile> {
        private ZipRemovalListener() {
        }

        public void onRemoval(RemovalNotification<ModelCoordinate, ZipFile> notification) {
            Zips.closeQuietly((ZipFile)((ZipFile)notification.getValue()));
        }
    }
}

